/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util.micrometer;

import io.camunda.zeebe.util.micrometer.ExtendedMeterDocumentation;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public final class StatefulMeterRegistry
extends CompositeMeterRegistry {
    private final ConcurrentMap<Meter.Id, StatefulGauge> gauges = new ConcurrentHashMap<Meter.Id, StatefulGauge>();

    public StatefulMeterRegistry() {
    }

    public StatefulMeterRegistry(MeterRegistry wrapped, Tags tags) {
        this();
        this.add(wrapped);
        this.config().commonTags((Iterable)tags);
    }

    public StatefulGauge newLongGauge(ExtendedMeterDocumentation documentation) {
        return this.newLongGauge(documentation, Tags.empty());
    }

    public StatefulGauge newLongGauge(ExtendedMeterDocumentation documentation, Tag ... tags) {
        return this.newLongGauge(documentation, Tags.of((Tag[])tags));
    }

    public StatefulGauge newLongGauge(ExtendedMeterDocumentation documentation, String ... tags) {
        return this.newLongGauge(documentation, Tags.of((String[])tags));
    }

    public StatefulGauge newLongGauge(ExtendedMeterDocumentation documentation, Tags tags) {
        Meter.Type type = documentation.getType();
        if (type != Meter.Type.GAUGE) {
            throw new IllegalArgumentException("Expected to register a new stateful long gauge, but it's documented as a meter of type %s".formatted(type));
        }
        Meter.Id id = new Meter.Id(documentation.getName(), tags, documentation.getBaseUnit(), documentation.getDescription(), type);
        StatefulGauge existing = (StatefulGauge)this.gauges.get(id);
        if (existing != null) {
            return existing;
        }
        AtomicLong state = new AtomicLong();
        Gauge gauge = Gauge.builder((String)id.getName(), (Object)state, AtomicLong::get).description(id.getDescription()).tags((Iterable)id.getTags()).strongReference(true).register((MeterRegistry)this);
        StatefulGauge statefulGauge = new StatefulGauge(gauge, state);
        this.gauges.put(id, statefulGauge);
        return statefulGauge;
    }

    public Meter remove(Meter.Id mappedId) {
        Meter removed = super.remove(mappedId);
        if (mappedId.getType() == Meter.Type.GAUGE) {
            this.gauges.remove(mappedId);
        }
        return removed;
    }

    public record StatefulGauge(Gauge gauge, AtomicLong state) {
    }
}

