/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util.micrometer;

import io.camunda.zeebe.util.micrometer.ExtendedMeterDocumentation;
import io.camunda.zeebe.util.micrometer.StatefulGauge;
import io.micrometer.common.docs.KeyName;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.HashMap;
import java.util.Map;

public final class EnumMeter<T extends Enum<T>> {
    private final Map<T, StatefulGauge> states;

    private EnumMeter(Map<T, StatefulGauge> states) {
        this.states = states;
    }

    public static <T extends Enum<T>> EnumMeter<T> register(Class<T> stateClass, ExtendedMeterDocumentation documentation, KeyName stateTag, MeterRegistry registry) {
        HashMap<Enum, StatefulGauge> states = new HashMap<Enum, StatefulGauge>();
        for (Enum state : (Enum[])stateClass.getEnumConstants()) {
            StatefulGauge gauge = StatefulGauge.builder(documentation.getName()).description(documentation.getDescription()).tag(stateTag.asString(), state.name()).register(registry);
            states.put(state, gauge);
        }
        return new EnumMeter(states);
    }

    public void state(T state) {
        for (Map.Entry<T, StatefulGauge> entry : this.states.entrySet()) {
            entry.getValue().set(entry.getKey() == state);
        }
    }
}

