/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util.micrometer;

import io.camunda.zeebe.util.micrometer.StatefulGauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class StatefulMeterRegistry
extends CompositeMeterRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatefulMeterRegistry.class);
    private final ConcurrentMap<Meter.Id, StatefulGauge> gauges = new ConcurrentHashMap<Meter.Id, StatefulGauge>();

    StatefulMeterRegistry(MeterRegistry parent) {
        super(parent.config().clock(), Collections.singleton(parent));
        this.config().onMeterAdded(this::onMeterAdded).onMeterRemoved(this::onMeterRemoved);
    }

    StatefulGauge registerIfNecessary(Meter.Id id) {
        return this.gauges.computeIfAbsent(id, this::registerStatefulGauge);
    }

    StatefulGauge registerStatefulGauge(Meter.Id id) {
        return StatefulGauge.registerAsGauge(id, (MeterRegistry)this);
    }

    private void onMeterAdded(Meter meter) {
        StatefulGauge existing = (StatefulGauge)((Object)this.gauges.get(meter.getId()));
        if (existing != null && existing.delegate() != meter) {
            LOGGER.warn("A new meter {} was added a the stateful meter registry, but there was already an existing stateful gauge; this is probably a mistake", (Object)meter.getId());
        }
    }

    private void onMeterRemoved(Meter meter) {
        this.gauges.remove(meter.getId());
    }
}

