/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util;

import java.util.concurrent.ThreadLocalRandom;
import java.util.function.DoubleSupplier;
import java.util.function.LongUnaryOperator;

public final class ExponentialBackoff
implements LongUnaryOperator {
    private static final long DEFAULT_MAX_RETRY_DELAY_MS = 5000L;
    private static final long DEFAULT_MIN_RETRY_DELAY_MS = 100L;
    private static final double DEFAULT_BACKOFF_FACTOR = 1.6;
    private static final double DEFAULT_JITTER_FACTOR = 0.1;
    private final long maxDelay;
    private final long minDelay;
    private final double backoffFactor;
    private final double jitterFactor;
    private final DoubleSupplier random;

    public ExponentialBackoff() {
        this(5000L, 100L, 1.6, 0.1);
    }

    public ExponentialBackoff(long maxDelay, long minDelay) {
        this(maxDelay, minDelay, 1.6, 0.1);
    }

    public ExponentialBackoff(long maxDelay, long minDelay, double backoffFactor, double jitterFactor) {
        this(maxDelay, minDelay, backoffFactor, jitterFactor, () -> ThreadLocalRandom.current().nextDouble());
    }

    ExponentialBackoff(long maxDelay, long minDelay, double backoffFactor, double jitterFactor, DoubleSupplier random) {
        this.maxDelay = maxDelay;
        this.minDelay = minDelay;
        this.backoffFactor = backoffFactor;
        this.jitterFactor = jitterFactor;
        this.random = random;
    }

    @Override
    public long applyAsLong(long operand) {
        return this.supplyRetryDelay(operand);
    }

    public long supplyRetryDelay(long currentRetryDelay) {
        double delay = Math.max(Math.min((double)this.maxDelay, (double)currentRetryDelay * this.backoffFactor), (double)this.minDelay);
        double jitter = this.computeJitter(delay);
        return Math.round(delay + jitter);
    }

    private double computeJitter(double value) {
        double minFactor = value * -this.jitterFactor;
        double maxFactor = value * this.jitterFactor;
        return this.random.getAsDouble() * (maxFactor - minFactor) + minFactor;
    }
}

