/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util.collection;

import io.camunda.zeebe.util.collection.MArray;
import io.camunda.zeebe.util.function.TriFunction;
import java.util.HashMap;
import java.util.Map;
import java.util.function.IntFunction;

public interface Map3D<RowT, ColT, FaceT, T> {
    public T get(RowT var1, ColT var2, FaceT var3);

    public void put(RowT var1, ColT var2, FaceT var3, T var4);

    public T computeIfAbsent(RowT var1, ColT var2, FaceT var3, TriFunction<RowT, ColT, FaceT, T> var4);

    public static <RowT, ColT, FaceT, T> Map3D<RowT, ColT, FaceT, T> simple() {
        return new HashMap3D();
    }

    public static <RowT extends Enum<RowT>, ColT extends Enum<ColT>, FaceT extends Enum<FaceT>, T> Map3D<RowT, ColT, FaceT, T> ofEnum(Class<RowT> rowClass, Class<ColT> columnClass, Class<FaceT> faceClass, IntFunction<T[]> arraySupplier) {
        MArray marray = MArray.of(arraySupplier, ((Enum[])rowClass.getEnumConstants()).length, ((Enum[])columnClass.getEnumConstants()).length, ((Enum[])faceClass.getEnumConstants()).length);
        return new EnumMap3D(marray);
    }

    public static final class HashMap3D<RowT, ColT, FaceT, T>
    implements Map3D<RowT, ColT, FaceT, T> {
        private final Map<RowT, Map<ColT, Map<FaceT, T>>> cube = new HashMap<RowT, Map<ColT, Map<FaceT, T>>>();

        @Override
        public T get(RowT rowKey, ColT columnKey, FaceT faceKey) {
            Map<ColT, Map<FaceT, T>> row = this.cube.get(rowKey);
            if (row == null) {
                return null;
            }
            Map<FaceT, T> column = row.get(columnKey);
            return column == null ? null : (T)column.get(faceKey);
        }

        @Override
        public void put(RowT rowKey, ColT columnKey, FaceT faceKey, T value) {
            this.cube.computeIfAbsent(rowKey, ignored -> new HashMap()).computeIfAbsent(columnKey, ignored -> new HashMap()).put(faceKey, value);
        }

        @Override
        public T computeIfAbsent(RowT rowKey, ColT columnKey, FaceT faceKey, TriFunction<RowT, ColT, FaceT, T> computer) {
            return (T)this.cube.computeIfAbsent(rowKey, ignored -> new HashMap()).computeIfAbsent(columnKey, ignored -> new HashMap()).computeIfAbsent(faceKey, ignored -> computer.apply(rowKey, columnKey, faceKey));
        }
    }

    public static final class EnumMap3D<RowT extends Enum<RowT>, ColT extends Enum<ColT>, FaceT extends Enum<FaceT>, T>
    implements Map3D<RowT, ColT, FaceT, T> {
        private final MArray<T> marray;

        private EnumMap3D(MArray<T> marray) {
            this.marray = marray;
        }

        @Override
        public T get(RowT rowKey, ColT columnKey, FaceT faceKey) {
            return this.marray.get(((Enum)rowKey).ordinal(), ((Enum)columnKey).ordinal(), ((Enum)faceKey).ordinal());
        }

        @Override
        public void put(RowT rowKey, ColT columnKey, FaceT faceKey, T value) {
            this.marray.put(value, ((Enum)rowKey).ordinal(), ((Enum)columnKey).ordinal(), ((Enum)faceKey).ordinal());
        }

        @Override
        public T computeIfAbsent(RowT rowKey, ColT columnKey, FaceT faceKey, TriFunction<RowT, ColT, FaceT, T> computer) {
            T value = this.get(rowKey, columnKey, faceKey);
            if (value != null) {
                return value;
            }
            T updated = computer.apply(rowKey, columnKey, faceKey);
            this.put(rowKey, columnKey, faceKey, updated);
            return updated;
        }
    }
}

