/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util.micrometer;

import io.camunda.zeebe.util.micrometer.ExtendedMeterDocumentation;
import io.micrometer.common.docs.KeyName;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public final class EnumMeter<T extends Enum<T>> {
    private final Map<T, AtomicBoolean> states;

    private EnumMeter(Map<T, AtomicBoolean> states) {
        this.states = states;
    }

    public static <T extends Enum<T>> EnumMeter<T> register(Class<T> stateClass, ExtendedMeterDocumentation documentation, KeyName stateTag, MeterRegistry registry) {
        HashMap<Enum, AtomicBoolean> states = new HashMap<Enum, AtomicBoolean>();
        for (Enum state : (Enum[])stateClass.getEnumConstants()) {
            AtomicBoolean value = new AtomicBoolean(false);
            states.put(state, value);
            Gauge.builder((String)documentation.getName(), (Object)value, bool -> bool.get() ? 1.0 : 0.0).description(documentation.getDescription()).tag(stateTag.asString(), state.name()).register(registry);
        }
        return new EnumMeter(states);
    }

    public void state(T state) {
        for (Map.Entry<T, AtomicBoolean> entry : this.states.entrySet()) {
            entry.getValue().set(entry.getKey() == state);
        }
    }
}

