/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util.micrometer;

import io.camunda.zeebe.util.CloseableSilently;
import io.micrometer.common.docs.KeyName;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.LongConsumer;

public final class MicrometerUtil {
    private static final Duration[] DEFAULT_PROMETHEUS_BUCKETS = new Duration[]{Duration.ofMillis(5L), Duration.ofMillis(10L), Duration.ofMillis(25L), Duration.ofMillis(50L), Duration.ofMillis(100L), Duration.ofMillis(75L), Duration.ofMillis(100L), Duration.ofMillis(250L), Duration.ofMillis(500L), Duration.ofMillis(750L), Duration.ofSeconds(1L), Duration.ofMillis(2500L), Duration.ofSeconds(5L), Duration.ofMillis(7500L), Duration.ofSeconds(10L)};

    private MicrometerUtil() {
    }

    public static Duration[] defaultPrometheusBuckets() {
        return DEFAULT_PROMETHEUS_BUCKETS;
    }

    public static CloseableSilently timer(Timer timer, Timer.Sample sample) {
        return new CloseableTimer(timer, sample);
    }

    public static CloseableSilently timer(LongConsumer setter, TimeUnit unit, Clock clock) {
        return new CloseableGaugeTimer(setter, unit, clock, clock.monotonicTime());
    }

    public static void closeRegistry(MeterRegistry registry) {
        registry.clear();
        registry.close();
    }

    private record CloseableTimer(Timer timer, Timer.Sample sample) implements CloseableSilently
    {
        @Override
        public void close() {
            this.sample.stop(this.timer);
        }
    }

    private record CloseableGaugeTimer(LongConsumer setter, TimeUnit unit, Clock clock, long startNanos) implements CloseableSilently
    {
        @Override
        public void close() {
            this.setter.accept(this.unit.convert(this.clock.monotonicTime() - this.startNanos, TimeUnit.NANOSECONDS));
        }
    }

    public static enum PartitionKeyNames implements KeyName
    {
        PARTITION{

            public String asString() {
                return "partition";
            }
        };

    }
}

