/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.behavior;

import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.BpmnProcessingException;
import io.camunda.zeebe.engine.processing.common.CatchEventBehavior;
import io.camunda.zeebe.engine.processing.common.EventTriggerBehavior;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCatchEventSupplier;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowElement;
import io.camunda.zeebe.engine.processing.streamprocessor.sideeffect.SideEffects;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedCommandWriter;
import io.camunda.zeebe.engine.state.KeyGenerator;
import io.camunda.zeebe.engine.state.deployment.DeployedProcess;
import io.camunda.zeebe.engine.state.immutable.EventScopeInstanceState;
import io.camunda.zeebe.engine.state.immutable.ProcessState;
import io.camunda.zeebe.engine.state.immutable.ZeebeState;
import io.camunda.zeebe.engine.state.instance.EventTrigger;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.util.Either;
import java.util.Optional;

public final class BpmnEventSubscriptionBehavior {
    private static final String NO_PROCESS_FOUND_MESSAGE = "Expected to create an instance of process with key '%d', but no such process was found";
    private final ProcessInstanceRecord eventRecord = new ProcessInstanceRecord();
    private final EventScopeInstanceState eventScopeInstanceState;
    private final CatchEventBehavior catchEventBehavior;
    private final SideEffects sideEffects;
    private final KeyGenerator keyGenerator;
    private final ProcessState processState;
    private final TypedCommandWriter commandWriter;
    private final EventTriggerBehavior eventTriggerBehavior;

    public BpmnEventSubscriptionBehavior(CatchEventBehavior catchEventBehavior, EventTriggerBehavior eventTriggerBehavior, TypedCommandWriter commandWriter, SideEffects sideEffects, ZeebeState zeebeState, KeyGenerator keyGenerator) {
        this.catchEventBehavior = catchEventBehavior;
        this.eventTriggerBehavior = eventTriggerBehavior;
        this.commandWriter = commandWriter;
        this.sideEffects = sideEffects;
        this.processState = zeebeState.getProcessState();
        this.eventScopeInstanceState = zeebeState.getEventScopeInstanceState();
        this.keyGenerator = keyGenerator;
    }

    public <T extends ExecutableCatchEventSupplier> Either<Failure, Void> subscribeToEvents(T element, BpmnElementContext context) {
        return this.catchEventBehavior.subscribeToEvents(context, element, this.sideEffects, this.commandWriter);
    }

    public void unsubscribeFromEvents(BpmnElementContext context) {
        this.catchEventBehavior.unsubscribeFromEvents(context, this.commandWriter, this.sideEffects);
    }

    public Optional<EventTrigger> findEventTrigger(BpmnElementContext context) {
        long elementInstanceKey = context.getElementInstanceKey();
        return Optional.ofNullable(this.eventScopeInstanceState.peekEventTrigger(elementInstanceKey));
    }

    public void activateTriggeredEvent(long eventScopeKey, long flowScopeKey, EventTrigger eventTrigger, BpmnElementContext context) {
        ExecutableFlowElement triggeredEvent = this.processState.getFlowElement(context.getProcessDefinitionKey(), eventTrigger.getElementId(), ExecutableFlowElement.class);
        this.eventTriggerBehavior.activateTriggeredEvent(eventTrigger.getEventKey(), triggeredEvent, eventScopeKey, flowScopeKey, context.getRecordValue(), eventTrigger.getVariables());
    }

    public Optional<EventTrigger> getEventTriggerForProcessDefinition(long processDefinitionKey) {
        EventTrigger eventTrigger = this.eventScopeInstanceState.peekEventTrigger(processDefinitionKey);
        return Optional.ofNullable(eventTrigger);
    }

    public void activateTriggeredStartEvent(BpmnElementContext context, EventTrigger triggeredEvent) {
        long processDefinitionKey = context.getProcessDefinitionKey();
        long processInstanceKey = context.getProcessInstanceKey();
        DeployedProcess process = this.processState.getProcessByKey(context.getProcessDefinitionKey());
        if (process == null) {
            throw new BpmnProcessingException(context, String.format(NO_PROCESS_FOUND_MESSAGE, processDefinitionKey));
        }
        this.eventTriggerBehavior.processEventTriggered(triggeredEvent.getEventKey(), processDefinitionKey, processInstanceKey, processDefinitionKey, triggeredEvent.getElementId());
        this.eventRecord.reset();
        this.eventRecord.wrap(context.getRecordValue());
        ProcessInstanceRecord record = this.eventRecord.setElementId(triggeredEvent.getElementId()).setBpmnElementType(BpmnElementType.START_EVENT).setProcessInstanceKey(processInstanceKey).setVersion(process.getVersion()).setBpmnProcessId(process.getBpmnProcessId()).setFlowScopeKey(processInstanceKey);
        long newEventInstanceKey = this.keyGenerator.nextKey();
        this.commandWriter.appendFollowUpCommand(newEventInstanceKey, (Intent)ProcessInstanceIntent.ACTIVATE_ELEMENT, (RecordValue)record);
    }
}

