/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.behavior;

import io.camunda.zeebe.engine.metrics.JobMetrics;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.camunda.zeebe.engine.processing.common.ExpressionProcessor;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableJobWorkerElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.JobWorkerProperties;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedCommandWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.KeyGenerator;
import io.camunda.zeebe.engine.state.immutable.JobState;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.msgpack.value.DocumentValue;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.collection.Tuple;

public final class BpmnJobBehavior {
    private final JobRecord jobRecord = new JobRecord().setVariables(DocumentValue.EMPTY_DOCUMENT);
    private final KeyGenerator keyGenerator;
    private final StateWriter stateWriter;
    private final TypedCommandWriter commandWriter;
    private final JobState jobState;
    private final ExpressionProcessor expressionBehavior;
    private final BpmnStateBehavior stateBehavior;
    private final BpmnIncidentBehavior incidentBehavior;
    private final JobMetrics jobMetrics;

    public BpmnJobBehavior(KeyGenerator keyGenerator, JobState jobState, Writers writers, ExpressionProcessor expressionBehavior, BpmnStateBehavior stateBehavior, BpmnIncidentBehavior incidentBehavior, JobMetrics jobMetrics) {
        this.keyGenerator = keyGenerator;
        this.jobState = jobState;
        this.expressionBehavior = expressionBehavior;
        this.stateWriter = writers.state();
        this.commandWriter = writers.command();
        this.stateBehavior = stateBehavior;
        this.incidentBehavior = incidentBehavior;
        this.jobMetrics = jobMetrics;
    }

    public Either<Failure, ?> createNewJob(BpmnElementContext context, ExecutableJobWorkerElement jobWorkerElement) {
        return this.evaluateJobExpressions(context, jobWorkerElement.getJobWorkerProperties()).map(jobTypeAndRetries -> {
            String jobType = (String)jobTypeAndRetries.getLeft();
            int retries = ((Long)jobTypeAndRetries.getRight()).intValue();
            this.writeJobCreatedEvent(context, jobWorkerElement, jobType, retries);
            this.jobMetrics.jobCreated(jobType);
            return null;
        });
    }

    private Either<Failure, Tuple<String, Long>> evaluateJobExpressions(BpmnElementContext context, JobWorkerProperties jobWorkerProperties) {
        long scopeKey = context.getElementInstanceKey();
        return this.expressionBehavior.evaluateStringExpression(jobWorkerProperties.getType(), scopeKey).flatMap(jobType -> this.expressionBehavior.evaluateLongExpression(jobWorkerProperties.getRetries(), scopeKey).map(retries -> new Tuple(jobType, retries)));
    }

    private void writeJobCreatedEvent(BpmnElementContext context, ExecutableJobWorkerElement jobWorkerElement, String jobType, int retries) {
        this.jobRecord.setType(jobType).setRetries(retries).setCustomHeaders(jobWorkerElement.getJobWorkerProperties().getEncodedHeaders()).setBpmnProcessId(context.getBpmnProcessId()).setProcessDefinitionVersion(context.getProcessVersion()).setProcessDefinitionKey(context.getProcessDefinitionKey()).setProcessInstanceKey(context.getProcessInstanceKey()).setElementId(jobWorkerElement.getId()).setElementInstanceKey(context.getElementInstanceKey());
        long jobKey = this.keyGenerator.nextKey();
        this.stateWriter.appendFollowUpEvent(jobKey, (Intent)JobIntent.CREATED, (RecordValue)this.jobRecord);
    }

    public void cancelJob(BpmnElementContext context) {
        ElementInstance elementInstance = this.stateBehavior.getElementInstance(context);
        long jobKey = elementInstance.getJobKey();
        if (jobKey > 0L) {
            this.writeJobCancelCommand(jobKey);
            this.incidentBehavior.resolveJobIncident(jobKey);
        }
    }

    private void writeJobCancelCommand(long jobKey) {
        JobState.State state = this.jobState.getState(jobKey);
        if (state == JobState.State.ACTIVATABLE || state == JobState.State.ACTIVATED || state == JobState.State.FAILED) {
            JobRecord job = this.jobState.getJob(jobKey);
            this.commandWriter.appendFollowUpCommand(jobKey, (Intent)JobIntent.CANCEL, (RecordValue)job);
        }
    }
}

