/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.job;

import io.camunda.zeebe.engine.processing.streamprocessor.ReadonlyProcessingContext;
import io.camunda.zeebe.engine.processing.streamprocessor.StreamProcessorLifecycleAware;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedCommandWriter;
import io.camunda.zeebe.engine.state.immutable.JobState;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.util.sched.ScheduledTimer;
import io.camunda.zeebe.util.sched.clock.ActorClock;
import java.time.Duration;

public final class JobTimeoutTrigger
implements StreamProcessorLifecycleAware {
    public static final Duration TIME_OUT_POLLING_INTERVAL = Duration.ofSeconds(30L);
    private final JobState state;
    private ScheduledTimer timer;
    private TypedCommandWriter writer;
    private ReadonlyProcessingContext processingContext;

    public JobTimeoutTrigger(JobState state) {
        this.state = state;
    }

    @Override
    public void onRecovered(ReadonlyProcessingContext processingContext) {
        this.processingContext = processingContext;
        this.timer = this.processingContext.getActor().runAtFixedRate(TIME_OUT_POLLING_INTERVAL, this::deactivateTimedOutJobs);
        this.writer = processingContext.getLogStreamWriter();
    }

    @Override
    public void onClose() {
        this.cancelTimer();
    }

    @Override
    public void onFailed() {
        this.cancelTimer();
    }

    @Override
    public void onPaused() {
        this.cancelTimer();
    }

    @Override
    public void onResumed() {
        if (this.timer == null) {
            this.timer = this.processingContext.getActor().runAtFixedRate(TIME_OUT_POLLING_INTERVAL, this::deactivateTimedOutJobs);
        }
    }

    private void cancelTimer() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    void deactivateTimedOutJobs() {
        long now = ActorClock.currentTimeMillis();
        this.state.forEachTimedOutEntry(now, (key, record) -> {
            this.writer.reset();
            this.writer.appendFollowUpCommand((long)key, (Intent)JobIntent.TIME_OUT, (RecordValue)record);
            return this.writer.flush() >= 0L;
        });
    }
}

