/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.message.command;

import io.camunda.zeebe.engine.processing.message.command.BooleanType;
import io.camunda.zeebe.engine.processing.message.command.OpenProcessMessageSubscriptionDecoder;
import io.camunda.zeebe.engine.processing.message.command.OpenProcessMessageSubscriptionEncoder;
import io.camunda.zeebe.protocol.impl.encoding.SbeBufferWriterReader;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class OpenProcessMessageSubscriptionCommand
extends SbeBufferWriterReader<OpenProcessMessageSubscriptionEncoder, OpenProcessMessageSubscriptionDecoder> {
    private final OpenProcessMessageSubscriptionEncoder encoder = new OpenProcessMessageSubscriptionEncoder();
    private final OpenProcessMessageSubscriptionDecoder decoder = new OpenProcessMessageSubscriptionDecoder();
    private final UnsafeBuffer messageName = new UnsafeBuffer(0L, 0);
    private int subscriptionPartitionId;
    private long processInstanceKey;
    private long elementInstanceKey;
    private boolean closeOnCorrelate;

    protected OpenProcessMessageSubscriptionEncoder getBodyEncoder() {
        return this.encoder;
    }

    protected OpenProcessMessageSubscriptionDecoder getBodyDecoder() {
        return this.decoder;
    }

    public void reset() {
        this.subscriptionPartitionId = OpenProcessMessageSubscriptionDecoder.subscriptionPartitionIdNullValue();
        this.processInstanceKey = OpenProcessMessageSubscriptionDecoder.processInstanceKeyNullValue();
        this.elementInstanceKey = OpenProcessMessageSubscriptionDecoder.elementInstanceKeyNullValue();
        this.messageName.wrap(0L, 0);
    }

    public int getLength() {
        return super.getLength() + OpenProcessMessageSubscriptionDecoder.messageNameHeaderLength() + this.messageName.capacity();
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        super.write(buffer, offset);
        this.encoder.subscriptionPartitionId(this.subscriptionPartitionId).processInstanceKey(this.processInstanceKey).elementInstanceKey(this.elementInstanceKey).closeOnCorrelate(this.closeOnCorrelate ? BooleanType.TRUE : BooleanType.FALSE).putMessageName((DirectBuffer)this.messageName, 0, this.messageName.capacity());
    }

    public void wrap(DirectBuffer buffer, int offset, int length) {
        super.wrap(buffer, offset, length);
        this.subscriptionPartitionId = this.decoder.subscriptionPartitionId();
        this.processInstanceKey = this.decoder.processInstanceKey();
        this.elementInstanceKey = this.decoder.elementInstanceKey();
        this.closeOnCorrelate = this.decoder.closeOnCorrelate() == BooleanType.TRUE;
        offset = this.decoder.limit();
        int messageNameLength = this.decoder.messageNameLength();
        this.messageName.wrap(buffer, offset += OpenProcessMessageSubscriptionDecoder.messageNameHeaderLength(), messageNameLength);
    }

    public int getSubscriptionPartitionId() {
        return this.subscriptionPartitionId;
    }

    public void setSubscriptionPartitionId(int subscriptionPartitionId) {
        this.subscriptionPartitionId = subscriptionPartitionId;
    }

    public long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    public void setProcessInstanceKey(long processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
    }

    public long getElementInstanceKey() {
        return this.elementInstanceKey;
    }

    public void setElementInstanceKey(long elementInstanceKey) {
        this.elementInstanceKey = elementInstanceKey;
    }

    public DirectBuffer getMessageName() {
        return this.messageName;
    }

    public boolean shouldCloseOnCorrelate() {
        return this.closeOnCorrelate;
    }

    public void setCloseOnCorrelate(boolean closeOnCorrelate) {
        this.closeOnCorrelate = closeOnCorrelate;
    }
}

