/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn;

import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Arrays;
import org.agrona.DirectBuffer;

public final class ProcessInstanceStateTransitionGuard {
    private final BpmnStateBehavior stateBehavior;

    public ProcessInstanceStateTransitionGuard(BpmnStateBehavior stateBehavior) {
        this.stateBehavior = stateBehavior;
    }

    public Either<Failure, ?> isValidStateTransition(BpmnElementContext context) {
        return this.checkStateTransition(context).mapLeft(Failure::new);
    }

    private Either<String, ?> checkStateTransition(BpmnElementContext context) {
        switch (context.getIntent()) {
            case ACTIVATE_ELEMENT: {
                return this.hasActiveFlowScopeInstance(context);
            }
            case COMPLETE_ELEMENT: {
                return this.hasElementInstanceWithState(context, ProcessInstanceIntent.ELEMENT_ACTIVATED, ProcessInstanceIntent.ELEMENT_COMPLETING).flatMap(ok -> this.hasActiveFlowScopeInstance(context));
            }
            case TERMINATE_ELEMENT: {
                return this.hasElementInstanceWithState(context, ProcessInstanceIntent.ELEMENT_ACTIVATING, ProcessInstanceIntent.ELEMENT_ACTIVATED, ProcessInstanceIntent.ELEMENT_COMPLETING);
            }
        }
        return Either.left((Object)String.format("Expected the check of the preconditions of a command with intent [activate,complete,terminate] but the intent was '%s'", context.getIntent()));
    }

    private Either<String, ElementInstance> getElementInstance(BpmnElementContext context) {
        ElementInstance elementInstance = this.stateBehavior.getElementInstance(context);
        if (elementInstance != null) {
            return Either.right((Object)((Object)elementInstance));
        }
        return Either.left((Object)String.format("Expected element instance with key '%d' to be present in state but not found.", context.getElementInstanceKey()));
    }

    private Either<String, ElementInstance> getFlowScopeInstance(BpmnElementContext context) {
        ElementInstance flowScopeInstance = this.stateBehavior.getFlowScopeInstance(context);
        if (flowScopeInstance != null) {
            return Either.right((Object)((Object)flowScopeInstance));
        }
        return Either.left((Object)String.format("Expected flow scope instance with key '%d' to be present in state but not found.", context.getFlowScopeKey()));
    }

    private Either<String, ElementInstance> hasElementInstanceInState(ElementInstance elementInstance, ProcessInstanceIntent expectedState, ProcessInstanceIntent ... otherExpected) {
        ProcessInstanceIntent currentState = elementInstance.getState();
        if (expectedState != currentState && !Arrays.asList(otherExpected).contains(currentState)) {
            return Either.left((Object)String.format("Expected element instance to be in state '%s' or one of '%s' but was '%s'.", expectedState, Arrays.toString(otherExpected), currentState));
        }
        return Either.right((Object)((Object)elementInstance));
    }

    private Either<String, ?> hasElementInstanceWithState(BpmnElementContext context, ProcessInstanceIntent expectedState, ProcessInstanceIntent ... otherExpected) {
        return this.getElementInstance(context).flatMap(elementInstance -> this.hasElementInstanceInState((ElementInstance)((Object)elementInstance), expectedState, otherExpected));
    }

    private Either<String, ElementInstance> hasFlowScopeInstanceInState(ElementInstance flowScopeInstance, ProcessInstanceIntent expectedState) {
        ProcessInstanceIntent currentState = flowScopeInstance.getState();
        if (currentState != expectedState) {
            return Either.left((Object)String.format("Expected flow scope instance to be in state '%s' but was '%s'.", expectedState, currentState));
        }
        return Either.right((Object)((Object)flowScopeInstance));
    }

    private Either<String, ElementInstance> hasNonInterruptedFlowScope(ElementInstance flowScopeInstance, BpmnElementContext context) {
        DirectBuffer interruptingElementId = flowScopeInstance.getInterruptingElementId();
        if (flowScopeInstance.isInterrupted() && !interruptingElementId.equals(context.getElementId())) {
            return Either.left((Object)String.format("Expected flow scope instance to be not interrupted but was interrupted by an event with id '%s'.", BufferUtil.bufferAsString((DirectBuffer)interruptingElementId)));
        }
        return Either.right((Object)((Object)flowScopeInstance));
    }

    private Either<String, ?> hasActiveFlowScopeInstance(BpmnElementContext context) {
        if (context.getBpmnElementType() == BpmnElementType.PROCESS) {
            return Either.right(null);
        }
        return this.getFlowScopeInstance(context).flatMap(flowScopeInstance -> this.hasFlowScopeInstanceInState((ElementInstance)((Object)flowScopeInstance), ProcessInstanceIntent.ELEMENT_ACTIVATED)).flatMap(flowScopeInstance -> this.hasNonInterruptedFlowScope((ElementInstance)((Object)flowScopeInstance), context));
    }
}

