/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.transformer;

import io.camunda.zeebe.el.Expression;
import io.camunda.zeebe.el.ExpressionLanguage;
import io.camunda.zeebe.engine.Loggers;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableJobWorkerElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableProcess;
import io.camunda.zeebe.engine.processing.deployment.model.element.JobWorkerProperties;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.ModelElementTransformer;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.TransformContext;
import io.camunda.zeebe.model.bpmn.instance.FlowElement;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeHeader;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeTaskDefinition;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeTaskHeaders;
import io.camunda.zeebe.msgpack.spec.MsgPackWriter;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.List;
import java.util.stream.Collectors;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.slf4j.Logger;

public final class JobWorkerElementTransformer<T extends FlowElement>
implements ModelElementTransformer<T> {
    private static final Logger LOG = Loggers.STREAM_PROCESSING;
    private static final int INITIAL_SIZE_KEY_VALUE_PAIR = 128;
    private final MsgPackWriter msgPackWriter = new MsgPackWriter();
    private final Class<T> type;

    public JobWorkerElementTransformer(Class<T> type) {
        this.type = type;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public void transform(T element, TransformContext context) {
        ExecutableProcess process = context.getCurrentProcess();
        ExecutableJobWorkerElement jobWorkerElement = process.getElementById(element.getId(), ExecutableJobWorkerElement.class);
        JobWorkerProperties jobWorkerProperties = new JobWorkerProperties();
        jobWorkerElement.setJobWorkerProperties(jobWorkerProperties);
        this.transformTaskDefinition(element, jobWorkerProperties, context);
        this.transformTaskHeaders(element, jobWorkerProperties);
    }

    private void transformTaskDefinition(T element, JobWorkerProperties jobWorkerProperties, TransformContext context) {
        ZeebeTaskDefinition taskDefinition = (ZeebeTaskDefinition)element.getSingleExtensionElement(ZeebeTaskDefinition.class);
        ExpressionLanguage expressionLanguage = context.getExpressionLanguage();
        Expression jobTypeExpression = expressionLanguage.parseExpression(taskDefinition.getType());
        jobWorkerProperties.setType(jobTypeExpression);
        Expression retriesExpression = expressionLanguage.parseExpression(taskDefinition.getRetries());
        jobWorkerProperties.setRetries(retriesExpression);
    }

    private void transformTaskHeaders(T element, JobWorkerProperties jobWorkerProperties) {
        ZeebeTaskHeaders taskHeaders = (ZeebeTaskHeaders)element.getSingleExtensionElement(ZeebeTaskHeaders.class);
        if (taskHeaders != null) {
            List<ZeebeHeader> validHeaders = taskHeaders.getHeaders().stream().filter(this::isValidHeader).collect(Collectors.toList());
            if (validHeaders.size() < taskHeaders.getHeaders().size()) {
                LOG.warn("Ignoring invalid headers for task '{}'. Must have non-empty key and value.", (Object)element.getName());
            }
            if (!validHeaders.isEmpty()) {
                DirectBuffer encodedHeaders = this.encode(validHeaders);
                jobWorkerProperties.setEncodedHeaders(encodedHeaders);
            }
        }
    }

    private DirectBuffer encode(List<ZeebeHeader> taskHeaders) {
        UnsafeBuffer buffer = new UnsafeBuffer(0L, 0);
        ExpandableArrayBuffer expandableBuffer = new ExpandableArrayBuffer(128 * taskHeaders.size());
        this.msgPackWriter.wrap((MutableDirectBuffer)expandableBuffer, 0);
        this.msgPackWriter.writeMapHeader(taskHeaders.size());
        taskHeaders.forEach(h -> {
            if (this.isValidHeader((ZeebeHeader)h)) {
                DirectBuffer key = BufferUtil.wrapString((String)h.getKey());
                this.msgPackWriter.writeString(key);
                DirectBuffer value = BufferUtil.wrapString((String)h.getValue());
                this.msgPackWriter.writeString(value);
            }
        });
        buffer.wrap(expandableBuffer.byteArray(), 0, this.msgPackWriter.getOffset());
        return buffer;
    }

    private boolean isValidHeader(ZeebeHeader header) {
        return header != null && header.getValue() != null && !header.getValue().isEmpty() && header.getKey() != null && !header.getKey().isEmpty();
    }
}

