/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.appliers;

import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCatchEvent;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableStartEvent;
import io.camunda.zeebe.engine.state.immutable.ProcessState;
import io.camunda.zeebe.engine.state.mutable.MutableElementInstanceState;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import org.agrona.DirectBuffer;

public class EventSubProcessInterruptionMarker {
    private final ProcessState processState;
    private final MutableElementInstanceState elementInstanceState;

    public EventSubProcessInterruptionMarker(ProcessState processState, MutableElementInstanceState elementInstanceState) {
        this.processState = processState;
        this.elementInstanceState = elementInstanceState;
    }

    public void markInstanceIfInterrupted(long flowScopeElementInstanceKey, long processDefinitionKey, DirectBuffer elementId) {
        ExecutableCatchEvent catchEvent = this.processState.getFlowElement(processDefinitionKey, elementId, ExecutableCatchEvent.class);
        if (!this.isRootStartEvent(flowScopeElementInstanceKey) && catchEvent.getFlowScope().getElementType() == BpmnElementType.EVENT_SUB_PROCESS && catchEvent instanceof ExecutableStartEvent && catchEvent.isInterrupting()) {
            ExecutableStartEvent executableStartEvent = (ExecutableStartEvent)catchEvent;
            this.elementInstanceState.updateInstance(flowScopeElementInstanceKey, flowScopeElementInstance -> flowScopeElementInstance.setInterruptingElementId(executableStartEvent.getEventSubProcess()));
        }
    }

    private boolean isRootStartEvent(long elementInstanceKey) {
        return elementInstanceKey < 0L;
    }
}

