/* Generated SBE (Simple Binary Encoding) message codec. */
package io.camunda.zeebe.engine.processing.message.command;

import org.agrona.MutableDirectBuffer;
import org.agrona.DirectBuffer;
import org.agrona.sbe.*;

@SuppressWarnings("all")
public final class CorrelateMessageSubscriptionEncoder implements MessageEncoderFlyweight
{
    public static final int BLOCK_LENGTH = 18;
    public static final int TEMPLATE_ID = 3;
    public static final int SCHEMA_ID = 6;
    public static final int SCHEMA_VERSION = 1;
    public static final java.nio.ByteOrder BYTE_ORDER = java.nio.ByteOrder.LITTLE_ENDIAN;

    private final CorrelateMessageSubscriptionEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;

    public int sbeBlockLength()
    {
        return BLOCK_LENGTH;
    }

    public int sbeTemplateId()
    {
        return TEMPLATE_ID;
    }

    public int sbeSchemaId()
    {
        return SCHEMA_ID;
    }

    public int sbeSchemaVersion()
    {
        return SCHEMA_VERSION;
    }

    public String sbeSemanticType()
    {
        return "";
    }

    public MutableDirectBuffer buffer()
    {
        return buffer;
    }

    public int initialOffset()
    {
        return initialOffset;
    }

    public int offset()
    {
        return offset;
    }

    public CorrelateMessageSubscriptionEncoder wrap(final MutableDirectBuffer buffer, final int offset)
    {
        if (buffer != this.buffer)
        {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        limit(offset + BLOCK_LENGTH);

        return this;
    }

    public CorrelateMessageSubscriptionEncoder wrapAndApplyHeader(
        final MutableDirectBuffer buffer, final int offset, final MessageHeaderEncoder headerEncoder)
    {
        headerEncoder
            .wrap(buffer, offset)
            .blockLength(BLOCK_LENGTH)
            .templateId(TEMPLATE_ID)
            .schemaId(SCHEMA_ID)
            .version(SCHEMA_VERSION);

        return wrap(buffer, offset + MessageHeaderEncoder.ENCODED_LENGTH);
    }

    public int encodedLength()
    {
        return limit - offset;
    }

    public int limit()
    {
        return limit;
    }

    public void limit(final int limit)
    {
        this.limit = limit;
    }

    public static int subscriptionPartitionIdId()
    {
        return 0;
    }

    public static int subscriptionPartitionIdSinceVersion()
    {
        return 0;
    }

    public static int subscriptionPartitionIdEncodingOffset()
    {
        return 0;
    }

    public static int subscriptionPartitionIdEncodingLength()
    {
        return 2;
    }

    public static String subscriptionPartitionIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int subscriptionPartitionIdNullValue()
    {
        return 65535;
    }

    public static int subscriptionPartitionIdMinValue()
    {
        return 0;
    }

    public static int subscriptionPartitionIdMaxValue()
    {
        return 65534;
    }

    public CorrelateMessageSubscriptionEncoder subscriptionPartitionId(final int value)
    {
        buffer.putShort(offset + 0, (short)value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int processInstanceKeyId()
    {
        return 1;
    }

    public static int processInstanceKeySinceVersion()
    {
        return 0;
    }

    public static int processInstanceKeyEncodingOffset()
    {
        return 2;
    }

    public static int processInstanceKeyEncodingLength()
    {
        return 8;
    }

    public static String processInstanceKeyMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long processInstanceKeyNullValue()
    {
        return 0xffffffffffffffffL;
    }

    public static long processInstanceKeyMinValue()
    {
        return 0x0L;
    }

    public static long processInstanceKeyMaxValue()
    {
        return 0xfffffffffffffffeL;
    }

    public CorrelateMessageSubscriptionEncoder processInstanceKey(final long value)
    {
        buffer.putLong(offset + 2, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int elementInstanceKeyId()
    {
        return 2;
    }

    public static int elementInstanceKeySinceVersion()
    {
        return 0;
    }

    public static int elementInstanceKeyEncodingOffset()
    {
        return 10;
    }

    public static int elementInstanceKeyEncodingLength()
    {
        return 8;
    }

    public static String elementInstanceKeyMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long elementInstanceKeyNullValue()
    {
        return 0xffffffffffffffffL;
    }

    public static long elementInstanceKeyMinValue()
    {
        return 0x0L;
    }

    public static long elementInstanceKeyMaxValue()
    {
        return 0xfffffffffffffffeL;
    }

    public CorrelateMessageSubscriptionEncoder elementInstanceKey(final long value)
    {
        buffer.putLong(offset + 10, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int messageNameId()
    {
        return 3;
    }

    public static String messageNameCharacterEncoding()
    {
        return "UTF-8";
    }

    public static String messageNameMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int messageNameHeaderLength()
    {
        return 4;
    }

    public CorrelateMessageSubscriptionEncoder putMessageName(final DirectBuffer src, final int srcOffset, final int length)
    {
        if (length > 2147483647)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public CorrelateMessageSubscriptionEncoder putMessageName(final byte[] src, final int srcOffset, final int length)
    {
        if (length > 2147483647)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public CorrelateMessageSubscriptionEncoder messageName(final String value)
    {
        final byte[] bytes;
        try
        {
            bytes = null == value || value.isEmpty() ? org.agrona.collections.ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes("UTF-8");
        }
        catch (final java.io.UnsupportedEncodingException ex)
        {
            throw new RuntimeException(ex);
        }

        final int length = bytes.length;
        if (length > 2147483647)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
        buffer.putBytes(limit + headerLength, bytes, 0, length);

        return this;
    }

    public static int bpmnProcessIdId()
    {
        return 4;
    }

    public static String bpmnProcessIdCharacterEncoding()
    {
        return "UTF-8";
    }

    public static String bpmnProcessIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int bpmnProcessIdHeaderLength()
    {
        return 4;
    }

    public CorrelateMessageSubscriptionEncoder putBpmnProcessId(final DirectBuffer src, final int srcOffset, final int length)
    {
        if (length > 2147483647)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public CorrelateMessageSubscriptionEncoder putBpmnProcessId(final byte[] src, final int srcOffset, final int length)
    {
        if (length > 2147483647)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public CorrelateMessageSubscriptionEncoder bpmnProcessId(final String value)
    {
        final byte[] bytes;
        try
        {
            bytes = null == value || value.isEmpty() ? org.agrona.collections.ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes("UTF-8");
        }
        catch (final java.io.UnsupportedEncodingException ex)
        {
            throw new RuntimeException(ex);
        }

        final int length = bytes.length;
        if (length > 2147483647)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
        buffer.putBytes(limit + headerLength, bytes, 0, length);

        return this;
    }

    public String toString()
    {
        if (null == buffer)
        {
            return "";
        }

        return appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        if (null == buffer)
        {
            return builder;
        }

        final CorrelateMessageSubscriptionDecoder decoder = new CorrelateMessageSubscriptionDecoder();
        decoder.wrap(buffer, initialOffset, BLOCK_LENGTH, SCHEMA_VERSION);

        return decoder.appendTo(builder);
    }
}
