/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.metrics;

import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.prometheus.client.Counter;

public final class ProcessEngineMetrics {
    private static final String ORGANIZATION_ID = System.getenv().getOrDefault("CAMUNDA_CLOUD_ORGANIZATION_ID", "null");
    private static final String ACTION_ACTIVATED = "activated";
    private static final String ACTION_COMPLETED = "completed";
    private static final String ACTION_TERMINATED = "terminated";
    private static final Counter ELEMENT_INSTANCE_EVENTS = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("zeebe")).name("element_instance_events_total")).help("Number of process element instance events")).labelNames(new String[]{"action", "type", "partition"})).register();
    private static final Counter EXECUTED_INSTANCES = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("zeebe")).name("executed_instances_total")).help("Number of executed instances")).labelNames(new String[]{"organizationId", "type", "action", "partition"})).register();
    private final String partitionIdLabel;

    public ProcessEngineMetrics(int partitionId) {
        this.partitionIdLabel = String.valueOf(partitionId);
    }

    private void elementInstanceEvent(String action, BpmnElementType elementType) {
        ((Counter.Child)ELEMENT_INSTANCE_EVENTS.labels(new String[]{action, elementType.name(), this.partitionIdLabel})).inc();
    }

    private void increaseRootProcessInstance(String action) {
        ((Counter.Child)EXECUTED_INSTANCES.labels(new String[]{ORGANIZATION_ID, "ROOT_PROCESS_INSTANCE", action, this.partitionIdLabel})).inc();
    }

    public void elementInstanceActivated(BpmnElementContext context) {
        BpmnElementType elementType = context.getBpmnElementType();
        this.elementInstanceEvent(ACTION_ACTIVATED, elementType);
        if (this.isRootProcessInstance(elementType, context.getParentProcessInstanceKey())) {
            this.increaseRootProcessInstance(ACTION_ACTIVATED);
        }
    }

    public void elementInstanceCompleted(BpmnElementContext context) {
        BpmnElementType elementType = context.getBpmnElementType();
        this.elementInstanceEvent(ACTION_COMPLETED, elementType);
        if (this.isRootProcessInstance(elementType, context.getParentProcessInstanceKey())) {
            this.increaseRootProcessInstance(ACTION_COMPLETED);
        }
    }

    public void elementInstanceTerminated(BpmnElementContext context) {
        BpmnElementType elementType = context.getBpmnElementType();
        this.elementInstanceEvent(ACTION_TERMINATED, elementType);
        if (this.isRootProcessInstance(elementType, context.getParentProcessInstanceKey())) {
            this.increaseRootProcessInstance(ACTION_TERMINATED);
        }
    }

    private boolean isProcessInstance(BpmnElementType elementType) {
        return BpmnElementType.PROCESS == elementType;
    }

    private boolean isRootProcessInstance(BpmnElementType elementType, long parentProcessInstanceKey) {
        return this.isProcessInstance(elementType) && parentProcessInstanceKey == -1L;
    }
}

