/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.gateway;

import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementProcessor;
import io.camunda.zeebe.engine.processing.bpmn.BpmnProcessingException;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnEventSubscriptionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableEventBasedGateway;
import io.camunda.zeebe.engine.state.instance.EventTrigger;

public final class EventBasedGatewayProcessor
implements BpmnElementProcessor<ExecutableEventBasedGateway> {
    private final BpmnStateTransitionBehavior stateTransitionBehavior;
    private final BpmnEventSubscriptionBehavior eventSubscriptionBehavior;
    private final BpmnIncidentBehavior incidentBehavior;

    public EventBasedGatewayProcessor(BpmnBehaviors bpmnBehaviors) {
        this.stateTransitionBehavior = bpmnBehaviors.stateTransitionBehavior();
        this.eventSubscriptionBehavior = bpmnBehaviors.eventSubscriptionBehavior();
        this.incidentBehavior = bpmnBehaviors.incidentBehavior();
    }

    @Override
    public Class<ExecutableEventBasedGateway> getType() {
        return ExecutableEventBasedGateway.class;
    }

    @Override
    public void onActivate(ExecutableEventBasedGateway element, BpmnElementContext context) {
        this.eventSubscriptionBehavior.subscribeToEvents(element, context).ifRightOrLeft(ok -> this.stateTransitionBehavior.transitionToActivated(context), failure -> this.incidentBehavior.createIncident((Failure)failure, context));
    }

    @Override
    public void onComplete(ExecutableEventBasedGateway element, BpmnElementContext context) {
        this.eventSubscriptionBehavior.unsubscribeFromEvents(context);
        EventTrigger eventTrigger = this.eventSubscriptionBehavior.findEventTrigger(context).orElseThrow(() -> new BpmnProcessingException(context, "Expected an event trigger to complete the event-based gateway but not found."));
        this.stateTransitionBehavior.transitionToCompleted(element, context).ifRightOrLeft(completed -> this.eventSubscriptionBehavior.activateTriggeredEvent(context.getElementInstanceKey(), completed.getFlowScopeKey(), eventTrigger, (BpmnElementContext)completed), failure -> this.incidentBehavior.createIncident((Failure)failure, context));
    }

    @Override
    public void onTerminate(ExecutableEventBasedGateway element, BpmnElementContext context) {
        this.eventSubscriptionBehavior.unsubscribeFromEvents(context);
        this.incidentBehavior.resolveIncidents(context);
        BpmnElementContext terminated = this.stateTransitionBehavior.transitionToTerminated(context);
        this.stateTransitionBehavior.onElementTerminated(element, terminated);
    }
}

