/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.job;

import io.camunda.zeebe.engine.metrics.JobMetrics;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnEventPublicationBehavior;
import io.camunda.zeebe.engine.processing.common.EventHandle;
import io.camunda.zeebe.engine.processing.common.EventTriggerBehavior;
import io.camunda.zeebe.engine.processing.job.JobBackoffChecker;
import io.camunda.zeebe.engine.processing.job.JobBatchActivateProcessor;
import io.camunda.zeebe.engine.processing.job.JobCancelProcessor;
import io.camunda.zeebe.engine.processing.job.JobCompleteProcessor;
import io.camunda.zeebe.engine.processing.job.JobFailProcessor;
import io.camunda.zeebe.engine.processing.job.JobRecurProcessor;
import io.camunda.zeebe.engine.processing.job.JobThrowErrorProcessor;
import io.camunda.zeebe.engine.processing.job.JobTimeOutProcessor;
import io.camunda.zeebe.engine.processing.job.JobTimeoutTrigger;
import io.camunda.zeebe.engine.processing.job.JobUpdateRetriesProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.ReadonlyProcessingContext;
import io.camunda.zeebe.engine.processing.streamprocessor.StreamProcessorLifecycleAware;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessors;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.KeyGenerator;
import io.camunda.zeebe.engine.state.mutable.MutableJobState;
import io.camunda.zeebe.engine.state.mutable.MutableZeebeState;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobBatchIntent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import java.util.function.Consumer;

public final class JobEventProcessors {
    public static void addJobProcessors(TypedRecordProcessors typedRecordProcessors, MutableZeebeState zeebeState, final Consumer<String> onJobsAvailableCallback, BpmnEventPublicationBehavior eventPublicationBehavior, int maxRecordSize, Writers writers, JobMetrics jobMetrics, EventTriggerBehavior eventTriggerBehavior) {
        final MutableJobState jobState = zeebeState.getJobState();
        KeyGenerator keyGenerator = zeebeState.getKeyGenerator();
        EventHandle eventHandle = new EventHandle(keyGenerator, zeebeState.getEventScopeInstanceState(), writers, zeebeState.getProcessState(), eventTriggerBehavior);
        JobBackoffChecker jobBackoffChecker = new JobBackoffChecker(jobState);
        typedRecordProcessors.onCommand(ValueType.JOB, (Intent)JobIntent.COMPLETE, new JobCompleteProcessor(zeebeState, jobMetrics, eventHandle)).onCommand(ValueType.JOB, (Intent)JobIntent.FAIL, new JobFailProcessor(zeebeState, zeebeState.getKeyGenerator(), jobMetrics, jobBackoffChecker)).onCommand(ValueType.JOB, (Intent)JobIntent.THROW_ERROR, new JobThrowErrorProcessor(zeebeState, eventPublicationBehavior, keyGenerator, jobMetrics)).onCommand(ValueType.JOB, (Intent)JobIntent.TIME_OUT, new JobTimeOutProcessor(zeebeState, jobMetrics)).onCommand(ValueType.JOB, (Intent)JobIntent.UPDATE_RETRIES, new JobUpdateRetriesProcessor(zeebeState)).onCommand(ValueType.JOB, (Intent)JobIntent.CANCEL, new JobCancelProcessor(zeebeState, jobMetrics)).onCommand(ValueType.JOB, (Intent)JobIntent.RECUR_AFTER_BACKOFF, new JobRecurProcessor(zeebeState)).onCommand(ValueType.JOB_BATCH, (Intent)JobBatchIntent.ACTIVATE, new JobBatchActivateProcessor(writers, zeebeState, zeebeState.getKeyGenerator(), maxRecordSize, jobMetrics)).withListener(new JobTimeoutTrigger(jobState)).withListener(jobBackoffChecker).withListener(new StreamProcessorLifecycleAware(){

            @Override
            public void onRecovered(ReadonlyProcessingContext context) {
                jobState.setJobsAvailableCallback(onJobsAvailableCallback);
            }
        });
    }
}

