/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.message.command;

import io.camunda.zeebe.engine.processing.message.command.CloseMessageSubscriptionCommand;
import io.camunda.zeebe.engine.processing.message.command.CloseProcessMessageSubscriptionCommand;
import io.camunda.zeebe.engine.processing.message.command.CorrelateMessageSubscriptionCommand;
import io.camunda.zeebe.engine.processing.message.command.CorrelateProcessMessageSubscriptionCommand;
import io.camunda.zeebe.engine.processing.message.command.OpenMessageSubscriptionCommand;
import io.camunda.zeebe.engine.processing.message.command.OpenProcessMessageSubscriptionCommand;
import io.camunda.zeebe.engine.processing.message.command.PartitionCommandSender;
import io.camunda.zeebe.engine.processing.message.command.RejectCorrelateMessageSubscriptionCommand;
import io.camunda.zeebe.protocol.Protocol;
import io.camunda.zeebe.util.buffer.BufferWriter;
import org.agrona.DirectBuffer;

public class SubscriptionCommandSender {
    private final OpenMessageSubscriptionCommand openMessageSubscriptionCommand = new OpenMessageSubscriptionCommand();
    private final OpenProcessMessageSubscriptionCommand openProcessMessageSubscriptionCommand = new OpenProcessMessageSubscriptionCommand();
    private final CorrelateProcessMessageSubscriptionCommand correlateProcessMessageSubscriptionCommand = new CorrelateProcessMessageSubscriptionCommand();
    private final CorrelateMessageSubscriptionCommand correlateMessageSubscriptionCommand = new CorrelateMessageSubscriptionCommand();
    private final CloseMessageSubscriptionCommand closeMessageSubscriptionCommand = new CloseMessageSubscriptionCommand();
    private final CloseProcessMessageSubscriptionCommand closeProcessMessageSubscriptionCommand = new CloseProcessMessageSubscriptionCommand();
    private final RejectCorrelateMessageSubscriptionCommand rejectCorrelateMessageSubscriptionCommand = new RejectCorrelateMessageSubscriptionCommand();
    private final PartitionCommandSender partitionCommandSender;
    private final int senderPartition;

    public SubscriptionCommandSender(int senderPartition, PartitionCommandSender partitionCommandSender) {
        this.senderPartition = senderPartition;
        this.partitionCommandSender = partitionCommandSender;
    }

    public boolean openMessageSubscription(int subscriptionPartitionId, long processInstanceKey, long elementInstanceKey, DirectBuffer bpmnProcessId, DirectBuffer messageName, DirectBuffer correlationKey, boolean closeOnCorrelate) {
        this.openMessageSubscriptionCommand.setSubscriptionPartitionId(subscriptionPartitionId);
        this.openMessageSubscriptionCommand.setProcessInstanceKey(processInstanceKey);
        this.openMessageSubscriptionCommand.setElementInstanceKey(elementInstanceKey);
        this.openMessageSubscriptionCommand.getBpmnProcessId().wrap(bpmnProcessId);
        this.openMessageSubscriptionCommand.getMessageName().wrap(messageName);
        this.openMessageSubscriptionCommand.getCorrelationKey().wrap(correlationKey);
        this.openMessageSubscriptionCommand.setCloseOnCorrelate(closeOnCorrelate);
        return this.partitionCommandSender.sendCommand(subscriptionPartitionId, (BufferWriter)this.openMessageSubscriptionCommand);
    }

    public boolean openProcessMessageSubscription(long processInstanceKey, long elementInstanceKey, DirectBuffer messageName, boolean closeOnCorrelate) {
        int processInstancePartitionId = Protocol.decodePartitionId((long)processInstanceKey);
        this.openProcessMessageSubscriptionCommand.setSubscriptionPartitionId(this.senderPartition);
        this.openProcessMessageSubscriptionCommand.setProcessInstanceKey(processInstanceKey);
        this.openProcessMessageSubscriptionCommand.setElementInstanceKey(elementInstanceKey);
        this.openProcessMessageSubscriptionCommand.getMessageName().wrap(messageName);
        this.openProcessMessageSubscriptionCommand.setCloseOnCorrelate(closeOnCorrelate);
        return this.partitionCommandSender.sendCommand(processInstancePartitionId, (BufferWriter)this.openProcessMessageSubscriptionCommand);
    }

    public boolean correlateProcessMessageSubscription(long processInstanceKey, long elementInstanceKey, DirectBuffer bpmnProcessId, DirectBuffer messageName, long messageKey, DirectBuffer variables, DirectBuffer correlationKey) {
        int processInstancePartitionId = Protocol.decodePartitionId((long)processInstanceKey);
        this.correlateProcessMessageSubscriptionCommand.setSubscriptionPartitionId(this.senderPartition);
        this.correlateProcessMessageSubscriptionCommand.setProcessInstanceKey(processInstanceKey);
        this.correlateProcessMessageSubscriptionCommand.setElementInstanceKey(elementInstanceKey);
        this.correlateProcessMessageSubscriptionCommand.getBpmnProcessId().wrap(bpmnProcessId);
        this.correlateProcessMessageSubscriptionCommand.setMessageKey(messageKey);
        this.correlateProcessMessageSubscriptionCommand.getMessageName().wrap(messageName);
        this.correlateProcessMessageSubscriptionCommand.getVariables().wrap(variables);
        this.correlateProcessMessageSubscriptionCommand.getCorrelationKey().wrap(correlationKey);
        return this.partitionCommandSender.sendCommand(processInstancePartitionId, (BufferWriter)this.correlateProcessMessageSubscriptionCommand);
    }

    public boolean correlateMessageSubscription(int subscriptionPartitionId, long processInstanceKey, long elementInstanceKey, DirectBuffer bpmnProcessId, DirectBuffer messageName) {
        this.correlateMessageSubscriptionCommand.setSubscriptionPartitionId(subscriptionPartitionId);
        this.correlateMessageSubscriptionCommand.setProcessInstanceKey(processInstanceKey);
        this.correlateMessageSubscriptionCommand.setElementInstanceKey(elementInstanceKey);
        this.correlateMessageSubscriptionCommand.getBpmnProcessId().wrap(bpmnProcessId);
        this.correlateMessageSubscriptionCommand.getMessageName().wrap(messageName);
        return this.partitionCommandSender.sendCommand(subscriptionPartitionId, (BufferWriter)this.correlateMessageSubscriptionCommand);
    }

    public boolean closeMessageSubscription(int subscriptionPartitionId, long processInstanceKey, long elementInstanceKey, DirectBuffer messageName) {
        this.closeMessageSubscriptionCommand.setSubscriptionPartitionId(subscriptionPartitionId);
        this.closeMessageSubscriptionCommand.setProcessInstanceKey(processInstanceKey);
        this.closeMessageSubscriptionCommand.setElementInstanceKey(elementInstanceKey);
        this.closeMessageSubscriptionCommand.setMessageName(messageName);
        return this.partitionCommandSender.sendCommand(subscriptionPartitionId, (BufferWriter)this.closeMessageSubscriptionCommand);
    }

    public boolean closeProcessMessageSubscription(long processInstanceKey, long elementInstanceKey, DirectBuffer messageName) {
        int processInstancePartitionId = Protocol.decodePartitionId((long)processInstanceKey);
        this.closeProcessMessageSubscriptionCommand.setSubscriptionPartitionId(this.senderPartition);
        this.closeProcessMessageSubscriptionCommand.setProcessInstanceKey(processInstanceKey);
        this.closeProcessMessageSubscriptionCommand.setElementInstanceKey(elementInstanceKey);
        this.closeProcessMessageSubscriptionCommand.setMessageName(messageName);
        return this.partitionCommandSender.sendCommand(processInstancePartitionId, (BufferWriter)this.closeProcessMessageSubscriptionCommand);
    }

    public boolean rejectCorrelateMessageSubscription(long processInstanceKey, DirectBuffer bpmnProcessId, long messageKey, DirectBuffer messageName, DirectBuffer correlationKey) {
        int processInstancePartitionId = Protocol.decodePartitionId((long)processInstanceKey);
        this.rejectCorrelateMessageSubscriptionCommand.setSubscriptionPartitionId(this.senderPartition);
        this.rejectCorrelateMessageSubscriptionCommand.setProcessInstanceKey(processInstanceKey);
        this.rejectCorrelateMessageSubscriptionCommand.getBpmnProcessId().wrap(bpmnProcessId);
        this.rejectCorrelateMessageSubscriptionCommand.setMessageKey(messageKey);
        this.rejectCorrelateMessageSubscriptionCommand.getMessageName().wrap(messageName);
        this.rejectCorrelateMessageSubscriptionCommand.getCorrelationKey().wrap(correlationKey);
        return this.partitionCommandSender.sendCommand(processInstancePartitionId, (BufferWriter)this.rejectCorrelateMessageSubscriptionCommand);
    }
}

