/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.streamprocessor;

import io.camunda.zeebe.engine.processing.streamprocessor.TypedEventRegistry;
import io.camunda.zeebe.logstreams.log.LoggedEvent;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.util.ReflectUtil;
import io.camunda.zeebe.util.buffer.BufferReader;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;

public final class RecordValues {
    private final Map<ValueType, UnifiedRecordValue> eventCache;

    public RecordValues() {
        EnumMap cache = new EnumMap(ValueType.class);
        TypedEventRegistry.EVENT_REGISTRY.forEach((t, c) -> cache.put((ValueType)t, (UnifiedRecordValue)ReflectUtil.newInstance((Class)c)));
        this.eventCache = Collections.unmodifiableMap(cache);
    }

    public UnifiedRecordValue readRecordValue(LoggedEvent event, ValueType valueType) {
        UnifiedRecordValue value = this.eventCache.get(valueType);
        if (value != null) {
            value.reset();
            event.readValue((BufferReader)value);
        }
        return value;
    }
}

