/* Generated SBE (Simple Binary Encoding) message codec. */
package io.camunda.zeebe.engine.processing.message.command;

import org.agrona.MutableDirectBuffer;
import org.agrona.DirectBuffer;
import org.agrona.sbe.*;

@SuppressWarnings("all")
public final class CloseProcessMessageSubscriptionDecoder implements MessageDecoderFlyweight
{
    public static final int BLOCK_LENGTH = 18;
    public static final int TEMPLATE_ID = 5;
    public static final int SCHEMA_ID = 6;
    public static final int SCHEMA_VERSION = 1;
    public static final java.nio.ByteOrder BYTE_ORDER = java.nio.ByteOrder.LITTLE_ENDIAN;

    private final CloseProcessMessageSubscriptionDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength()
    {
        return BLOCK_LENGTH;
    }

    public int sbeTemplateId()
    {
        return TEMPLATE_ID;
    }

    public int sbeSchemaId()
    {
        return SCHEMA_ID;
    }

    public int sbeSchemaVersion()
    {
        return SCHEMA_VERSION;
    }

    public String sbeSemanticType()
    {
        return "";
    }

    public DirectBuffer buffer()
    {
        return buffer;
    }

    public int initialOffset()
    {
        return initialOffset;
    }

    public int offset()
    {
        return offset;
    }

    public CloseProcessMessageSubscriptionDecoder wrap(
        final DirectBuffer buffer,
        final int offset,
        final int actingBlockLength,
        final int actingVersion)
    {
        if (buffer != this.buffer)
        {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        limit(offset + actingBlockLength);

        return this;
    }

    public CloseProcessMessageSubscriptionDecoder wrapAndApplyHeader(
        final DirectBuffer buffer,
        final int offset,
        final MessageHeaderDecoder headerDecoder)
    {
        headerDecoder.wrap(buffer, offset);

        final int templateId = headerDecoder.templateId();
        if (TEMPLATE_ID != templateId)
        {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }

        return wrap(
            buffer,
            offset + MessageHeaderDecoder.ENCODED_LENGTH,
            headerDecoder.blockLength(),
            headerDecoder.version());
    }

    public CloseProcessMessageSubscriptionDecoder sbeRewind()
    {
        return wrap(buffer, initialOffset, actingBlockLength, actingVersion);
    }

    public int sbeDecodedLength()
    {
        final int currentLimit = limit();
        sbeSkip();
        final int decodedLength = encodedLength();
        limit(currentLimit);

        return decodedLength;
    }

    public int encodedLength()
    {
        return limit - offset;
    }

    public int limit()
    {
        return limit;
    }

    public void limit(final int limit)
    {
        this.limit = limit;
    }

    public static int subscriptionPartitionIdId()
    {
        return 0;
    }

    public static int subscriptionPartitionIdSinceVersion()
    {
        return 0;
    }

    public static int subscriptionPartitionIdEncodingOffset()
    {
        return 0;
    }

    public static int subscriptionPartitionIdEncodingLength()
    {
        return 2;
    }

    public static String subscriptionPartitionIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int subscriptionPartitionIdNullValue()
    {
        return 65535;
    }

    public static int subscriptionPartitionIdMinValue()
    {
        return 0;
    }

    public static int subscriptionPartitionIdMaxValue()
    {
        return 65534;
    }

    public int subscriptionPartitionId()
    {
        return (buffer.getShort(offset + 0, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF);
    }


    public static int processInstanceKeyId()
    {
        return 1;
    }

    public static int processInstanceKeySinceVersion()
    {
        return 0;
    }

    public static int processInstanceKeyEncodingOffset()
    {
        return 2;
    }

    public static int processInstanceKeyEncodingLength()
    {
        return 8;
    }

    public static String processInstanceKeyMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long processInstanceKeyNullValue()
    {
        return 0xffffffffffffffffL;
    }

    public static long processInstanceKeyMinValue()
    {
        return 0x0L;
    }

    public static long processInstanceKeyMaxValue()
    {
        return 0xfffffffffffffffeL;
    }

    public long processInstanceKey()
    {
        return buffer.getLong(offset + 2, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int elementInstanceKeyId()
    {
        return 2;
    }

    public static int elementInstanceKeySinceVersion()
    {
        return 0;
    }

    public static int elementInstanceKeyEncodingOffset()
    {
        return 10;
    }

    public static int elementInstanceKeyEncodingLength()
    {
        return 8;
    }

    public static String elementInstanceKeyMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long elementInstanceKeyNullValue()
    {
        return 0xffffffffffffffffL;
    }

    public static long elementInstanceKeyMinValue()
    {
        return 0x0L;
    }

    public static long elementInstanceKeyMaxValue()
    {
        return 0xfffffffffffffffeL;
    }

    public long elementInstanceKey()
    {
        return buffer.getLong(offset + 10, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int messageNameId()
    {
        return 3;
    }

    public static int messageNameSinceVersion()
    {
        return 0;
    }

    public static String messageNameCharacterEncoding()
    {
        return "UTF-8";
    }

    public static String messageNameMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int messageNameHeaderLength()
    {
        return 4;
    }

    public int messageNameLength()
    {
        final int limit = parentMessage.limit();
        return (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
    }

    public int skipMessageName()
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        final int dataOffset = limit + headerLength;
        parentMessage.limit(dataOffset + dataLength);

        return dataLength;
    }

    public int getMessageName(final MutableDirectBuffer dst, final int dstOffset, final int length)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        final int bytesCopied = Math.min(length, dataLength);
        parentMessage.limit(limit + headerLength + dataLength);
        buffer.getBytes(limit + headerLength, dst, dstOffset, bytesCopied);

        return bytesCopied;
    }

    public int getMessageName(final byte[] dst, final int dstOffset, final int length)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        final int bytesCopied = Math.min(length, dataLength);
        parentMessage.limit(limit + headerLength + dataLength);
        buffer.getBytes(limit + headerLength, dst, dstOffset, bytesCopied);

        return bytesCopied;
    }

    public void wrapMessageName(final DirectBuffer wrapBuffer)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        parentMessage.limit(limit + headerLength + dataLength);
        wrapBuffer.wrap(buffer, limit + headerLength, dataLength);
    }

    public String messageName()
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        parentMessage.limit(limit + headerLength + dataLength);

        if (0 == dataLength)
        {
            return "";
        }

        final byte[] tmp = new byte[dataLength];
        buffer.getBytes(limit + headerLength, tmp, 0, dataLength);

        final String value;
        try
        {
            value = new String(tmp, "UTF-8");
        }
        catch (final java.io.UnsupportedEncodingException ex)
        {
            throw new RuntimeException(ex);
        }

        return value;
    }

    public String toString()
    {
        if (null == buffer)
        {
            return "";
        }

        final CloseProcessMessageSubscriptionDecoder decoder = new CloseProcessMessageSubscriptionDecoder();
        decoder.wrap(buffer, initialOffset, actingBlockLength, actingVersion);

        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        if (null == buffer)
        {
            return builder;
        }

        final int originalLimit = limit();
        limit(initialOffset + actingBlockLength);
        builder.append("[CloseProcessMessageSubscription](sbeTemplateId=");
        builder.append(TEMPLATE_ID);
        builder.append("|sbeSchemaId=");
        builder.append(SCHEMA_ID);
        builder.append("|sbeSchemaVersion=");
        if (parentMessage.actingVersion != SCHEMA_VERSION)
        {
            builder.append(parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(SCHEMA_VERSION);
        builder.append("|sbeBlockLength=");
        if (actingBlockLength != BLOCK_LENGTH)
        {
            builder.append(actingBlockLength);
            builder.append('/');
        }
        builder.append(BLOCK_LENGTH);
        builder.append("):");
        builder.append("subscriptionPartitionId=");
        builder.append(subscriptionPartitionId());
        builder.append('|');
        builder.append("processInstanceKey=");
        builder.append(processInstanceKey());
        builder.append('|');
        builder.append("elementInstanceKey=");
        builder.append(elementInstanceKey());
        builder.append('|');
        builder.append("messageName=");
        builder.append('\'').append(messageName()).append('\'');

        limit(originalLimit);

        return builder;
    }
    
    public CloseProcessMessageSubscriptionDecoder sbeSkip()
    {
        sbeRewind();
        skipMessageName();

        return this;
    }
}
