/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing;

import io.camunda.zeebe.engine.metrics.JobMetrics;
import io.camunda.zeebe.engine.processing.bpmn.BpmnStreamProcessor;
import io.camunda.zeebe.engine.processing.common.CatchEventBehavior;
import io.camunda.zeebe.engine.processing.common.EventTriggerBehavior;
import io.camunda.zeebe.engine.processing.common.ExpressionProcessor;
import io.camunda.zeebe.engine.processing.message.PendingProcessMessageSubscriptionChecker;
import io.camunda.zeebe.engine.processing.message.ProcessMessageSubscriptionCorrelateProcessor;
import io.camunda.zeebe.engine.processing.message.ProcessMessageSubscriptionCreateProcessor;
import io.camunda.zeebe.engine.processing.message.ProcessMessageSubscriptionDeleteProcessor;
import io.camunda.zeebe.engine.processing.message.command.SubscriptionCommandSender;
import io.camunda.zeebe.engine.processing.processinstance.CreateProcessInstanceProcessor;
import io.camunda.zeebe.engine.processing.processinstance.CreateProcessInstanceWithResultProcessor;
import io.camunda.zeebe.engine.processing.processinstance.ProcessInstanceCommandProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessors;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.processing.timer.CancelTimerProcessor;
import io.camunda.zeebe.engine.processing.timer.DueDateTimerChecker;
import io.camunda.zeebe.engine.processing.timer.TriggerTimerProcessor;
import io.camunda.zeebe.engine.processing.variable.UpdateVariableDocumentProcessor;
import io.camunda.zeebe.engine.processing.variable.VariableBehavior;
import io.camunda.zeebe.engine.state.KeyGenerator;
import io.camunda.zeebe.engine.state.immutable.ElementInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableElementInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessMessageSubscriptionState;
import io.camunda.zeebe.engine.state.mutable.MutableZeebeState;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceCreationIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessMessageSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.TimerIntent;
import io.camunda.zeebe.protocol.record.intent.VariableDocumentIntent;
import java.util.Arrays;

public final class ProcessEventProcessors {
    public static TypedRecordProcessor<ProcessInstanceRecord> addProcessProcessors(MutableZeebeState zeebeState, ExpressionProcessor expressionProcessor, TypedRecordProcessors typedRecordProcessors, SubscriptionCommandSender subscriptionCommandSender, CatchEventBehavior catchEventBehavior, DueDateTimerChecker timerChecker, EventTriggerBehavior eventTriggerBehavior, Writers writers, JobMetrics jobMetrics) {
        MutableProcessMessageSubscriptionState subscriptionState = zeebeState.getProcessMessageSubscriptionState();
        VariableBehavior variableBehavior = new VariableBehavior(zeebeState.getVariableState(), writers.state(), zeebeState.getKeyGenerator());
        ProcessEventProcessors.addProcessInstanceCommandProcessor(typedRecordProcessors, zeebeState.getElementInstanceState());
        BpmnStreamProcessor bpmnStreamProcessor = new BpmnStreamProcessor(expressionProcessor, catchEventBehavior, variableBehavior, eventTriggerBehavior, zeebeState, writers, jobMetrics);
        ProcessEventProcessors.addBpmnStepProcessor(typedRecordProcessors, bpmnStreamProcessor);
        ProcessEventProcessors.addMessageStreamProcessors(typedRecordProcessors, subscriptionState, subscriptionCommandSender, eventTriggerBehavior, zeebeState, writers);
        ProcessEventProcessors.addTimerStreamProcessors(typedRecordProcessors, timerChecker, zeebeState, catchEventBehavior, eventTriggerBehavior, expressionProcessor, writers);
        ProcessEventProcessors.addVariableDocumentStreamProcessors(typedRecordProcessors, variableBehavior, zeebeState.getElementInstanceState(), zeebeState.getKeyGenerator(), writers.state());
        ProcessEventProcessors.addProcessInstanceCreationStreamProcessors(typedRecordProcessors, zeebeState, writers, variableBehavior);
        return bpmnStreamProcessor;
    }

    private static void addProcessInstanceCommandProcessor(TypedRecordProcessors typedRecordProcessors, MutableElementInstanceState elementInstanceState) {
        ProcessInstanceCommandProcessor commandProcessor = new ProcessInstanceCommandProcessor(elementInstanceState);
        Arrays.stream(ProcessInstanceIntent.values()).filter(ProcessInstanceIntent::isProcessInstanceCommand).forEach(intent -> typedRecordProcessors.onCommand(ValueType.PROCESS_INSTANCE, (Intent)intent, commandProcessor));
    }

    private static void addBpmnStepProcessor(TypedRecordProcessors typedRecordProcessors, BpmnStreamProcessor bpmnStepProcessor) {
        Arrays.stream(ProcessInstanceIntent.values()).filter(ProcessInstanceIntent::isBpmnElementCommand).forEach(intent -> typedRecordProcessors.onCommand(ValueType.PROCESS_INSTANCE, (Intent)intent, bpmnStepProcessor));
    }

    private static void addMessageStreamProcessors(TypedRecordProcessors typedRecordProcessors, MutableProcessMessageSubscriptionState subscriptionState, SubscriptionCommandSender subscriptionCommandSender, EventTriggerBehavior eventTriggerBehavior, MutableZeebeState zeebeState, Writers writers) {
        typedRecordProcessors.onCommand(ValueType.PROCESS_MESSAGE_SUBSCRIPTION, (Intent)ProcessMessageSubscriptionIntent.CREATE, new ProcessMessageSubscriptionCreateProcessor(zeebeState.getProcessMessageSubscriptionState(), writers)).onCommand(ValueType.PROCESS_MESSAGE_SUBSCRIPTION, (Intent)ProcessMessageSubscriptionIntent.CORRELATE, new ProcessMessageSubscriptionCorrelateProcessor(subscriptionState, subscriptionCommandSender, zeebeState, eventTriggerBehavior, writers)).onCommand(ValueType.PROCESS_MESSAGE_SUBSCRIPTION, (Intent)ProcessMessageSubscriptionIntent.DELETE, new ProcessMessageSubscriptionDeleteProcessor(subscriptionState, writers)).withListener(new PendingProcessMessageSubscriptionChecker(subscriptionCommandSender, zeebeState.getPendingProcessMessageSubscriptionState()));
    }

    private static void addTimerStreamProcessors(TypedRecordProcessors typedRecordProcessors, DueDateTimerChecker timerChecker, MutableZeebeState zeebeState, CatchEventBehavior catchEventOutput, EventTriggerBehavior eventTriggerBehavior, ExpressionProcessor expressionProcessor, Writers writers) {
        typedRecordProcessors.onCommand(ValueType.TIMER, (Intent)TimerIntent.TRIGGER, new TriggerTimerProcessor(zeebeState, catchEventOutput, eventTriggerBehavior, expressionProcessor, writers)).onCommand(ValueType.TIMER, (Intent)TimerIntent.CANCEL, new CancelTimerProcessor(zeebeState.getTimerState(), writers.state(), writers.rejection())).withListener(timerChecker);
    }

    private static void addVariableDocumentStreamProcessors(TypedRecordProcessors typedRecordProcessors, VariableBehavior variableBehavior, ElementInstanceState elementInstanceState, KeyGenerator keyGenerator, StateWriter stateWriter) {
        typedRecordProcessors.onCommand(ValueType.VARIABLE_DOCUMENT, (Intent)VariableDocumentIntent.UPDATE, new UpdateVariableDocumentProcessor(elementInstanceState, keyGenerator, variableBehavior, stateWriter));
    }

    private static void addProcessInstanceCreationStreamProcessors(TypedRecordProcessors typedRecordProcessors, MutableZeebeState zeebeState, Writers writers, VariableBehavior variableBehavior) {
        MutableElementInstanceState elementInstanceState = zeebeState.getElementInstanceState();
        KeyGenerator keyGenerator = zeebeState.getKeyGenerator();
        CreateProcessInstanceProcessor createProcessor = new CreateProcessInstanceProcessor(zeebeState.getProcessState(), keyGenerator, writers, variableBehavior);
        typedRecordProcessors.onCommand(ValueType.PROCESS_INSTANCE_CREATION, (Intent)ProcessInstanceCreationIntent.CREATE, createProcessor);
        typedRecordProcessors.onCommand(ValueType.PROCESS_INSTANCE_CREATION, (Intent)ProcessInstanceCreationIntent.CREATE_WITH_AWAITING_RESULT, new CreateProcessInstanceWithResultProcessor(createProcessor, elementInstanceState));
    }
}

