/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.streamprocessor;

import io.camunda.zeebe.engine.processing.streamprocessor.CommandProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.CommandProcessorImpl;
import io.camunda.zeebe.engine.processing.streamprocessor.RecordProcessorMap;
import io.camunda.zeebe.engine.processing.streamprocessor.StreamProcessorLifecycleAware;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.KeyGenerator;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import java.util.ArrayList;
import java.util.List;

public final class TypedRecordProcessors {
    private final RecordProcessorMap recordProcessorMap = new RecordProcessorMap();
    private final List<StreamProcessorLifecycleAware> lifecycleListeners = new ArrayList<StreamProcessorLifecycleAware>();
    private final KeyGenerator keyGenerator;
    private final Writers writers;

    private TypedRecordProcessors(KeyGenerator keyGenerator, Writers writers) {
        this.keyGenerator = keyGenerator;
        this.writers = writers;
    }

    public static TypedRecordProcessors processors(KeyGenerator keyGenerator, Writers writers) {
        return new TypedRecordProcessors(keyGenerator, writers);
    }

    public TypedRecordProcessors onCommand(ValueType valueType, Intent intent, TypedRecordProcessor<?> processor) {
        this.recordProcessorMap.put(RecordType.COMMAND, valueType, intent.value(), processor);
        return this;
    }

    public <T extends UnifiedRecordValue> TypedRecordProcessors onCommand(ValueType valueType, Intent intent, CommandProcessor<T> commandProcessor) {
        CommandProcessorImpl<T> processor = new CommandProcessorImpl<T>(commandProcessor, this.keyGenerator, this.writers);
        return this.onCommand(valueType, intent, processor);
    }

    public TypedRecordProcessors withListener(StreamProcessorLifecycleAware listener) {
        this.lifecycleListeners.add(listener);
        return this;
    }

    public RecordProcessorMap getRecordProcessorMap() {
        return this.recordProcessorMap;
    }

    public List<StreamProcessorLifecycleAware> getLifecycleListeners() {
        return this.lifecycleListeners;
    }
}

