/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.event;

import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContextImpl;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementProcessor;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnEventSubscriptionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnVariableMappingBehavior;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCatchEventSupplier;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableStartEvent;
import io.camunda.zeebe.engine.state.instance.ElementInstance;

public class StartEventProcessor
implements BpmnElementProcessor<ExecutableStartEvent> {
    private final BpmnStateTransitionBehavior stateTransitionBehavior;
    private final BpmnVariableMappingBehavior variableMappingBehavior;
    private final BpmnIncidentBehavior incidentBehavior;
    private final BpmnEventSubscriptionBehavior eventSubscriptionBehavior;
    private final BpmnStateBehavior stateBehavior;

    public StartEventProcessor(BpmnBehaviors bpmnBehaviors) {
        this.incidentBehavior = bpmnBehaviors.incidentBehavior();
        this.stateTransitionBehavior = bpmnBehaviors.stateTransitionBehavior();
        this.variableMappingBehavior = bpmnBehaviors.variableMappingBehavior();
        this.eventSubscriptionBehavior = bpmnBehaviors.eventSubscriptionBehavior();
        this.stateBehavior = bpmnBehaviors.stateBehavior();
    }

    @Override
    public Class<ExecutableStartEvent> getType() {
        return ExecutableStartEvent.class;
    }

    @Override
    public void onActivate(ExecutableStartEvent element, BpmnElementContext context) {
        BpmnElementContext activated = this.stateTransitionBehavior.transitionToActivated(context);
        this.stateTransitionBehavior.completeElement(activated);
    }

    @Override
    public void onComplete(ExecutableStartEvent element, BpmnElementContext context) {
        ExecutableCatchEventSupplier flowScope = (ExecutableCatchEventSupplier)element.getFlowScope();
        BpmnElementContextImpl flowScopeInstanceContext = this.buildContextForFlowScopeInstance(context);
        this.variableMappingBehavior.applyOutputMappings(context, element).flatMap(ok -> this.eventSubscriptionBehavior.subscribeToEvents(flowScope, flowScopeInstanceContext)).flatMap(ok -> this.stateTransitionBehavior.transitionToCompleted(element, context)).ifRightOrLeft(completed -> this.stateTransitionBehavior.takeOutgoingSequenceFlows(element, (BpmnElementContext)completed), failure -> this.incidentBehavior.createIncident((Failure)failure, context));
    }

    @Override
    public void onTerminate(ExecutableStartEvent element, BpmnElementContext context) {
        BpmnElementContext terminated = this.stateTransitionBehavior.transitionToTerminated(context);
        this.incidentBehavior.resolveIncidents(terminated);
        this.stateTransitionBehavior.onElementTerminated(element, terminated);
    }

    private BpmnElementContextImpl buildContextForFlowScopeInstance(BpmnElementContext context) {
        ElementInstance flowScopeInstance = this.stateBehavior.getFlowScopeInstance(context);
        BpmnElementContextImpl flowScopeInstanceContext = new BpmnElementContextImpl();
        flowScopeInstanceContext.init(flowScopeInstance.getKey(), flowScopeInstance.getValue(), flowScopeInstance.getState());
        return flowScopeInstanceContext;
    }
}

