/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.transform;

import io.camunda.zeebe.dmn.DecisionEngine;
import io.camunda.zeebe.dmn.DecisionEngineFactory;
import io.camunda.zeebe.dmn.ParsedDecision;
import io.camunda.zeebe.dmn.ParsedDecisionRequirementsGraph;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.transform.DeploymentResourceTransformer;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.state.KeyGenerator;
import io.camunda.zeebe.engine.state.deployment.PersistedDecisionRequirements;
import io.camunda.zeebe.engine.state.immutable.DecisionState;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DecisionRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DecisionRequirementsMetadataRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DecisionRequirementsRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentResource;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.intent.DecisionIntent;
import io.camunda.zeebe.protocol.record.intent.DecisionRequirementsIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.value.deployment.DecisionRequirementsMetadataValue;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import org.agrona.DirectBuffer;

public final class DmnResourceTransformer
implements DeploymentResourceTransformer {
    private static final int INITIAL_VERSION = 1;
    private static final Either<Failure, Object> NO_DUPLICATES = Either.right(null);
    private final DecisionEngine decisionEngine = DecisionEngineFactory.createDecisionEngine();
    private final KeyGenerator keyGenerator;
    private final StateWriter stateWriter;
    private final Function<DeploymentResource, DirectBuffer> checksumGenerator;
    private final DecisionState decisionState;

    public DmnResourceTransformer(KeyGenerator keyGenerator, StateWriter stateWriter, Function<DeploymentResource, DirectBuffer> checksumGenerator, DecisionState decisionState) {
        this.keyGenerator = keyGenerator;
        this.stateWriter = stateWriter;
        this.checksumGenerator = checksumGenerator;
        this.decisionState = decisionState;
    }

    @Override
    public Either<Failure, Void> transformResource(DeploymentResource resource, DeploymentRecord deployment) {
        ByteArrayInputStream dmnResource = new ByteArrayInputStream(resource.getResource());
        ParsedDecisionRequirementsGraph parsedDrg = this.decisionEngine.parse((InputStream)dmnResource);
        if (parsedDrg.isValid()) {
            return this.checkForDuplicateIds(resource, parsedDrg, deployment).map(noDuplicates -> {
                this.appendMetadataToDeploymentEvent(resource, parsedDrg, deployment);
                this.writeRecords(deployment, resource);
                return null;
            });
        }
        Failure failure = new Failure(parsedDrg.getFailureMessage());
        return Either.left((Object)failure);
    }

    private Either<Failure, ?> checkForDuplicateIds(DeploymentResource resource, ParsedDecisionRequirementsGraph parsedDrg, DeploymentRecord deploymentEvent) {
        return this.checkDuplicatedDrgIds(resource, parsedDrg, deploymentEvent).flatMap(noDuplicates -> this.checkDuplicatedDecisionIds(resource, parsedDrg, deploymentEvent));
    }

    private Either<Failure, ?> checkDuplicatedDrgIds(DeploymentResource resource, ParsedDecisionRequirementsGraph parsedDrg, DeploymentRecord deploymentEvent) {
        String decisionRequirementsId = parsedDrg.getId();
        return deploymentEvent.getDecisionRequirementsMetadata().stream().filter(drg -> drg.getDecisionRequirementsId().equals(decisionRequirementsId)).findFirst().map(duplicatedDrg -> {
            String failureMessage = String.format("Expected the decision requirements ids to be unique within a deployment but found a duplicated id '%s' in the resources '%s' and '%s'.", decisionRequirementsId, duplicatedDrg.getResourceName(), resource.getResourceName());
            return Either.left((Object)new Failure(failureMessage));
        }).orElse(NO_DUPLICATES);
    }

    private Either<Failure, ?> checkDuplicatedDecisionIds(DeploymentResource resource, ParsedDecisionRequirementsGraph parsedDrg, DeploymentRecord deploymentEvent) {
        List decisionIds = parsedDrg.getDecisions().stream().map(ParsedDecision::getId).collect(Collectors.toList());
        return deploymentEvent.getDecisionsMetadata().stream().filter(decision -> decisionIds.contains(decision.getDecisionId())).findFirst().map(duplicatedDecision -> {
            String failureMessage = String.format("Expected the decision ids to be unique within a deployment but found a duplicated id '%s' in the resources '%s' and '%s'.", duplicatedDecision.getDecisionId(), this.findResourceName(deploymentEvent, duplicatedDecision.getDecisionRequirementsKey()), resource.getResourceName());
            return Either.left((Object)new Failure(failureMessage));
        }).orElse(NO_DUPLICATES);
    }

    private String findResourceName(DeploymentRecord deploymentEvent, long decisionRequirementsKey) {
        return deploymentEvent.getDecisionRequirementsMetadata().stream().filter(drg -> drg.getDecisionRequirementsKey() == decisionRequirementsKey).map(DecisionRequirementsMetadataValue::getResourceName).findFirst().orElse("<?>");
    }

    private void appendMetadataToDeploymentEvent(DeploymentResource resource, ParsedDecisionRequirementsGraph parsedDrg, DeploymentRecord deploymentEvent) {
        LongSupplier newDecisionRequirementsKey = this.keyGenerator::nextKey;
        DirectBuffer checksum = this.checksumGenerator.apply(resource);
        DecisionRequirementsMetadataRecord drgRecord = (DecisionRequirementsMetadataRecord)deploymentEvent.decisionRequirementsMetadata().add();
        drgRecord.setDecisionRequirementsId(parsedDrg.getId()).setDecisionRequirementsName(parsedDrg.getName()).setNamespace(parsedDrg.getNamespace()).setResourceName(resource.getResourceName()).setChecksum(checksum);
        this.decisionState.findLatestDecisionRequirementsById(BufferUtil.wrapString((String)parsedDrg.getId())).ifPresentOrElse(latestDrg -> {
            int latestVersion = latestDrg.getDecisionRequirementsVersion();
            boolean isDuplicate = this.isDuplicate(resource, checksum, (PersistedDecisionRequirements)((Object)latestDrg));
            if (isDuplicate) {
                drgRecord.setDecisionRequirementsKey(latestDrg.getDecisionRequirementsKey()).setDecisionRequirementsVersion(latestVersion).markAsDuplicate();
            } else {
                drgRecord.setDecisionRequirementsKey(newDecisionRequirementsKey.getAsLong()).setDecisionRequirementsVersion(latestVersion + 1);
            }
        }, () -> drgRecord.setDecisionRequirementsKey(newDecisionRequirementsKey.getAsLong()).setDecisionRequirementsVersion(1));
        parsedDrg.getDecisions().forEach(decision -> {
            LongSupplier newDecisionKey = this.keyGenerator::nextKey;
            DecisionRecord decisionRecord = (DecisionRecord)deploymentEvent.decisionsMetadata().add();
            decisionRecord.setDecisionId(decision.getId()).setDecisionName(decision.getName()).setDecisionRequirementsId(parsedDrg.getId()).setDecisionRequirementsKey(drgRecord.getDecisionRequirementsKey());
            this.decisionState.findLatestDecisionById(BufferUtil.wrapString((String)decision.getId())).ifPresentOrElse(latestDecision -> {
                boolean isDuplicate;
                int latestVersion = latestDecision.getVersion();
                boolean bl = isDuplicate = latestDecision.getDecisionRequirementsKey() == drgRecord.getDecisionRequirementsKey();
                if (isDuplicate) {
                    decisionRecord.setDecisionKey(latestDecision.getDecisionKey()).setVersion(latestVersion).markAsDuplicate();
                } else {
                    decisionRecord.setDecisionKey(newDecisionKey.getAsLong()).setVersion(latestVersion + 1);
                }
            }, () -> decisionRecord.setDecisionKey(newDecisionKey.getAsLong()).setVersion(1));
        });
    }

    private boolean isDuplicate(DeploymentResource resource, DirectBuffer checksum, PersistedDecisionRequirements drg) {
        return drg.getResourceName().equals(resource.getResourceNameBuffer()) && drg.getChecksum().equals(checksum);
    }

    private void writeRecords(DeploymentRecord deployment, DeploymentResource resource) {
        for (DecisionRequirementsMetadataRecord drg : deployment.decisionRequirementsMetadata()) {
            if (drg.isDuplicate()) continue;
            this.stateWriter.appendFollowUpEvent(drg.getDecisionRequirementsKey(), (Intent)DecisionRequirementsIntent.CREATED, (RecordValue)new DecisionRequirementsRecord().setDecisionRequirementsKey(drg.getDecisionRequirementsKey()).setDecisionRequirementsId(drg.getDecisionRequirementsId()).setDecisionRequirementsName(drg.getDecisionRequirementsName()).setDecisionRequirementsVersion(drg.getDecisionRequirementsVersion()).setNamespace(drg.getNamespace()).setResourceName(drg.getResourceName()).setChecksum(drg.getChecksumBuffer()).setResource(resource.getResourceBuffer()));
        }
        for (DecisionRecord decision : deployment.decisionsMetadata()) {
            if (decision.isDuplicate()) continue;
            this.stateWriter.appendFollowUpEvent(decision.getDecisionKey(), (Intent)DecisionIntent.CREATED, (RecordValue)new DecisionRecord().setDecisionKey(decision.getDecisionKey()).setDecisionId(decision.getDecisionId()).setDecisionName(decision.getDecisionName()).setVersion(decision.getVersion()).setDecisionRequirementsId(decision.getDecisionRequirementsId()).setDecisionRequirementsKey(decision.getDecisionRequirementsKey()));
        }
    }
}

