/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.message.command;

import io.camunda.zeebe.engine.processing.message.command.CorrelateMessageSubscriptionDecoder;
import io.camunda.zeebe.engine.processing.message.command.MessageHeaderEncoder;
import io.camunda.zeebe.engine.processing.message.command.MetaAttribute;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.ArrayUtil;
import org.agrona.sbe.MessageEncoderFlyweight;

public final class CorrelateMessageSubscriptionEncoder
implements MessageEncoderFlyweight {
    public static final int BLOCK_LENGTH = 18;
    public static final int TEMPLATE_ID = 3;
    public static final int SCHEMA_ID = 6;
    public static final int SCHEMA_VERSION = 1;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final CorrelateMessageSubscriptionEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;

    public int sbeBlockLength() {
        return 18;
    }

    public int sbeTemplateId() {
        return 3;
    }

    public int sbeSchemaId() {
        return 6;
    }

    public int sbeSchemaVersion() {
        return 1;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public CorrelateMessageSubscriptionEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.limit(offset + 18);
        return this;
    }

    public CorrelateMessageSubscriptionEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(18).templateId(3).schemaId(6).version(1);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int subscriptionPartitionIdId() {
        return 0;
    }

    public static int subscriptionPartitionIdSinceVersion() {
        return 0;
    }

    public static int subscriptionPartitionIdEncodingOffset() {
        return 0;
    }

    public static int subscriptionPartitionIdEncodingLength() {
        return 2;
    }

    public static String subscriptionPartitionIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int subscriptionPartitionIdNullValue() {
        return 65535;
    }

    public static int subscriptionPartitionIdMinValue() {
        return 0;
    }

    public static int subscriptionPartitionIdMaxValue() {
        return 65534;
    }

    public CorrelateMessageSubscriptionEncoder subscriptionPartitionId(int value) {
        this.buffer.putShort(this.offset + 0, (short)value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int processInstanceKeyId() {
        return 1;
    }

    public static int processInstanceKeySinceVersion() {
        return 0;
    }

    public static int processInstanceKeyEncodingOffset() {
        return 2;
    }

    public static int processInstanceKeyEncodingLength() {
        return 8;
    }

    public static String processInstanceKeyMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long processInstanceKeyNullValue() {
        return -1L;
    }

    public static long processInstanceKeyMinValue() {
        return 0L;
    }

    public static long processInstanceKeyMaxValue() {
        return -2L;
    }

    public CorrelateMessageSubscriptionEncoder processInstanceKey(long value) {
        this.buffer.putLong(this.offset + 2, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int elementInstanceKeyId() {
        return 2;
    }

    public static int elementInstanceKeySinceVersion() {
        return 0;
    }

    public static int elementInstanceKeyEncodingOffset() {
        return 10;
    }

    public static int elementInstanceKeyEncodingLength() {
        return 8;
    }

    public static String elementInstanceKeyMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long elementInstanceKeyNullValue() {
        return -1L;
    }

    public static long elementInstanceKeyMinValue() {
        return 0L;
    }

    public static long elementInstanceKeyMaxValue() {
        return -2L;
    }

    public CorrelateMessageSubscriptionEncoder elementInstanceKey(long value) {
        this.buffer.putLong(this.offset + 10, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int messageNameId() {
        return 3;
    }

    public static String messageNameCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String messageNameMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int messageNameHeaderLength() {
        return 4;
    }

    public CorrelateMessageSubscriptionEncoder putMessageName(DirectBuffer src, int srcOffset, int length) {
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public CorrelateMessageSubscriptionEncoder putMessageName(byte[] src, int srcOffset, int length) {
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public CorrelateMessageSubscriptionEncoder messageName(String value) {
        byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
        int length = bytes.length;
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, bytes, 0, length);
        return this;
    }

    public static int bpmnProcessIdId() {
        return 4;
    }

    public static String bpmnProcessIdCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String bpmnProcessIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int bpmnProcessIdHeaderLength() {
        return 4;
    }

    public CorrelateMessageSubscriptionEncoder putBpmnProcessId(DirectBuffer src, int srcOffset, int length) {
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public CorrelateMessageSubscriptionEncoder putBpmnProcessId(byte[] src, int srcOffset, int length) {
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public CorrelateMessageSubscriptionEncoder bpmnProcessId(String value) {
        byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
        int length = bytes.length;
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, bytes, 0, length);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        CorrelateMessageSubscriptionDecoder decoder = new CorrelateMessageSubscriptionDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.initialOffset, 18, 1);
        return decoder.appendTo(builder);
    }
}

