/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.streamprocessor.writers;

import io.camunda.zeebe.engine.processing.streamprocessor.TypedEventRegistry;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecord;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedStreamWriter;
import io.camunda.zeebe.logstreams.log.LogStreamBatchWriter;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.protocol.impl.record.RecordMetadata;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.util.HashMap;
import java.util.Map;

public class TypedStreamWriterImpl
implements TypedStreamWriter {
    private final Map<Class<? extends UnpackedObject>, ValueType> typeRegistry;
    private final RecordMetadata metadata = new RecordMetadata();
    private final LogStreamBatchWriter batchWriter;
    private long sourceRecordPosition = -1L;

    public TypedStreamWriterImpl(LogStreamBatchWriter batchWriter) {
        this.batchWriter = batchWriter;
        this.typeRegistry = new HashMap<Class<? extends UnpackedObject>, ValueType>();
        TypedEventRegistry.EVENT_REGISTRY.forEach((e, c) -> this.typeRegistry.put((Class<? extends UnpackedObject>)c, (ValueType)e));
    }

    protected void initMetadata(RecordType type, Intent intent, RecordValue value) {
        this.metadata.reset();
        ValueType valueType = this.typeRegistry.get(value.getClass());
        if (valueType == null) {
            throw new RuntimeException("Missing value type mapping for record: " + value.getClass());
        }
        this.metadata.recordType(type).valueType(valueType).intent(intent);
    }

    protected void appendRecord(long key, RecordType type, Intent intent, RecordValue value) {
        this.appendRecord(key, type, intent, RejectionType.NULL_VAL, "", value);
    }

    protected void appendRecord(long key, RecordType type, Intent intent, RejectionType rejectionType, String rejectionReason, RecordValue value) {
        LogStreamBatchWriter.LogEntryBuilder event = this.batchWriter.event();
        if (this.sourceRecordPosition >= 0L) {
            this.batchWriter.sourceRecordPosition(this.sourceRecordPosition);
        }
        this.initMetadata(type, intent, value);
        this.metadata.rejectionType(rejectionType);
        this.metadata.rejectionReason(rejectionReason);
        if (key >= 0L) {
            event.key(key);
        } else {
            event.keyNull();
        }
        if (!(value instanceof BufferWriter)) {
            throw new RuntimeException(String.format("The record value %s is not a BufferWriter", value));
        }
        event.metadataWriter((BufferWriter)this.metadata).valueWriter((BufferWriter)value).done();
    }

    @Override
    public void appendNewCommand(Intent intent, RecordValue value) {
        this.appendRecord(-1L, RecordType.COMMAND, intent, value);
    }

    @Override
    public void appendFollowUpCommand(long key, Intent intent, RecordValue value) {
        this.appendRecord(key, RecordType.COMMAND, intent, value);
    }

    @Override
    public void reset() {
        this.sourceRecordPosition = -1L;
        this.metadata.reset();
        this.batchWriter.reset();
    }

    @Override
    public long flush() {
        return this.batchWriter.tryWrite();
    }

    @Override
    public void appendRejection(TypedRecord<? extends RecordValue> command, RejectionType rejectionType, String reason) {
        this.appendRecord(command.getKey(), RecordType.COMMAND_REJECTION, command.getIntent(), rejectionType, reason, command.getValue());
    }

    @Override
    public void configureSourceContext(long sourceRecordPosition) {
        this.sourceRecordPosition = sourceRecordPosition;
    }

    @Override
    public void appendFollowUpEvent(long key, Intent intent, RecordValue value) {
        this.appendRecord(key, RecordType.EVENT, intent, value);
    }

    @Override
    public boolean canWriteEventOfLength(int eventLength) {
        return this.batchWriter.canWriteAdditionalEvent(eventLength);
    }

    @Override
    public int getMaxEventLength() {
        return this.batchWriter.getMaxFragmentLength();
    }
}

