/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.job;

import io.camunda.zeebe.engine.metrics.JobMetrics;
import io.camunda.zeebe.engine.processing.streamprocessor.CommandProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecord;
import io.camunda.zeebe.engine.state.immutable.JobState;
import io.camunda.zeebe.engine.state.immutable.ZeebeState;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;

public final class JobTimeOutProcessor
implements CommandProcessor<JobRecord> {
    public static final String NOT_ACTIVATED_JOB_MESSAGE = "Expected to time out activated job with key '%d', but %s";
    private final JobState jobState;
    private final JobMetrics jobMetrics;

    public JobTimeOutProcessor(ZeebeState state, JobMetrics jobMetrics) {
        this.jobState = state.getJobState();
        this.jobMetrics = jobMetrics;
    }

    @Override
    public boolean onCommand(TypedRecord<JobRecord> command, CommandProcessor.CommandControl<JobRecord> commandControl) {
        long jobKey = command.getKey();
        JobState.State state = this.jobState.getState(jobKey);
        if (state == JobState.State.ACTIVATED) {
            commandControl.accept((Intent)JobIntent.TIMED_OUT, command.getValue());
            this.jobMetrics.jobTimedOut(command.getValue().getType());
        } else {
            commandControl.reject(RejectionType.NOT_FOUND, String.format(NOT_ACTIVATED_JOB_MESSAGE, jobKey, switch (state) {
                case JobState.State.ACTIVATABLE -> "it must be activated first";
                case JobState.State.FAILED -> "it is marked as failed";
                default -> "no such job was found";
            }));
        }
        return true;
    }
}

