/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.message.command;

import io.camunda.zeebe.engine.processing.message.command.BooleanType;
import io.camunda.zeebe.engine.processing.message.command.MessageHeaderDecoder;
import io.camunda.zeebe.engine.processing.message.command.MetaAttribute;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.MessageDecoderFlyweight;

public final class OpenMessageSubscriptionDecoder
implements MessageDecoderFlyweight {
    public static final int BLOCK_LENGTH = 19;
    public static final int TEMPLATE_ID = 0;
    public static final int SCHEMA_ID = 6;
    public static final int SCHEMA_VERSION = 1;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final OpenMessageSubscriptionDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength() {
        return 19;
    }

    public int sbeTemplateId() {
        return 0;
    }

    public int sbeSchemaId() {
        return 6;
    }

    public int sbeSchemaVersion() {
        return 1;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public OpenMessageSubscriptionDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public OpenMessageSubscriptionDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (0 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public OpenMessageSubscriptionDecoder sbeRewind() {
        return this.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int subscriptionPartitionIdId() {
        return 0;
    }

    public static int subscriptionPartitionIdSinceVersion() {
        return 0;
    }

    public static int subscriptionPartitionIdEncodingOffset() {
        return 0;
    }

    public static int subscriptionPartitionIdEncodingLength() {
        return 2;
    }

    public static String subscriptionPartitionIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int subscriptionPartitionIdNullValue() {
        return 65535;
    }

    public static int subscriptionPartitionIdMinValue() {
        return 0;
    }

    public static int subscriptionPartitionIdMaxValue() {
        return 65534;
    }

    public int subscriptionPartitionId() {
        return this.buffer.getShort(this.offset + 0, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public static int processInstanceKeyId() {
        return 1;
    }

    public static int processInstanceKeySinceVersion() {
        return 0;
    }

    public static int processInstanceKeyEncodingOffset() {
        return 2;
    }

    public static int processInstanceKeyEncodingLength() {
        return 8;
    }

    public static String processInstanceKeyMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long processInstanceKeyNullValue() {
        return -1L;
    }

    public static long processInstanceKeyMinValue() {
        return 0L;
    }

    public static long processInstanceKeyMaxValue() {
        return -2L;
    }

    public long processInstanceKey() {
        return this.buffer.getLong(this.offset + 2, ByteOrder.LITTLE_ENDIAN);
    }

    public static int elementInstanceKeyId() {
        return 2;
    }

    public static int elementInstanceKeySinceVersion() {
        return 0;
    }

    public static int elementInstanceKeyEncodingOffset() {
        return 10;
    }

    public static int elementInstanceKeyEncodingLength() {
        return 8;
    }

    public static String elementInstanceKeyMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long elementInstanceKeyNullValue() {
        return -1L;
    }

    public static long elementInstanceKeyMinValue() {
        return 0L;
    }

    public static long elementInstanceKeyMaxValue() {
        return -2L;
    }

    public long elementInstanceKey() {
        return this.buffer.getLong(this.offset + 10, ByteOrder.LITTLE_ENDIAN);
    }

    public static int closeOnCorrelateId() {
        return 3;
    }

    public static int closeOnCorrelateSinceVersion() {
        return 0;
    }

    public static int closeOnCorrelateEncodingOffset() {
        return 18;
    }

    public static int closeOnCorrelateEncodingLength() {
        return 1;
    }

    public static String closeOnCorrelateMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public short closeOnCorrelateRaw() {
        return (short)(this.buffer.getByte(this.offset + 18) & 0xFF);
    }

    public BooleanType closeOnCorrelate() {
        return BooleanType.get((short)(this.buffer.getByte(this.offset + 18) & 0xFF));
    }

    public static int messageNameId() {
        return 4;
    }

    public static int messageNameSinceVersion() {
        return 0;
    }

    public static String messageNameCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String messageNameMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int messageNameHeaderLength() {
        return 4;
    }

    public int messageNameLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
    }

    public int skipMessageName() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getMessageName(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getMessageName(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapMessageName(DirectBuffer wrapBuffer) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
    }

    public String messageName() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.UTF_8);
    }

    public static int correlationKeyId() {
        return 5;
    }

    public static int correlationKeySinceVersion() {
        return 0;
    }

    public static String correlationKeyCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String correlationKeyMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int correlationKeyHeaderLength() {
        return 4;
    }

    public int correlationKeyLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
    }

    public int skipCorrelationKey() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getCorrelationKey(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getCorrelationKey(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapCorrelationKey(DirectBuffer wrapBuffer) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
    }

    public String correlationKey() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.UTF_8);
    }

    public static int bpmnProcessIdId() {
        return 6;
    }

    public static int bpmnProcessIdSinceVersion() {
        return 0;
    }

    public static String bpmnProcessIdCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String bpmnProcessIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int bpmnProcessIdHeaderLength() {
        return 4;
    }

    public int bpmnProcessIdLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
    }

    public int skipBpmnProcessId() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getBpmnProcessId(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getBpmnProcessId(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapBpmnProcessId(DirectBuffer wrapBuffer) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
    }

    public String bpmnProcessId() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.UTF_8);
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        OpenMessageSubscriptionDecoder decoder = new OpenMessageSubscriptionDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[OpenMessageSubscription](sbeTemplateId=");
        builder.append(0);
        builder.append("|sbeSchemaId=");
        builder.append(6);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 1) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(1);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 19) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(19);
        builder.append("):");
        builder.append("subscriptionPartitionId=");
        builder.append(this.subscriptionPartitionId());
        builder.append('|');
        builder.append("processInstanceKey=");
        builder.append(this.processInstanceKey());
        builder.append('|');
        builder.append("elementInstanceKey=");
        builder.append(this.elementInstanceKey());
        builder.append('|');
        builder.append("closeOnCorrelate=");
        builder.append((Object)this.closeOnCorrelate());
        builder.append('|');
        builder.append("messageName=");
        builder.append('\'').append(this.messageName()).append('\'');
        builder.append('|');
        builder.append("correlationKey=");
        builder.append('\'').append(this.correlationKey()).append('\'');
        builder.append('|');
        builder.append("bpmnProcessId=");
        builder.append('\'').append(this.bpmnProcessId()).append('\'');
        this.limit(originalLimit);
        return builder;
    }

    public OpenMessageSubscriptionDecoder sbeSkip() {
        this.sbeRewind();
        this.skipMessageName();
        this.skipCorrelationKey();
        this.skipBpmnProcessId();
        return this;
    }
}

