/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.timer;

import io.camunda.zeebe.engine.processing.scheduled.DueDateChecker;
import io.camunda.zeebe.engine.processing.streamprocessor.ReadonlyProcessingContext;
import io.camunda.zeebe.engine.processing.streamprocessor.StreamProcessorLifecycleAware;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedCommandWriter;
import io.camunda.zeebe.engine.state.immutable.TimerInstanceState;
import io.camunda.zeebe.engine.state.instance.TimerInstance;
import io.camunda.zeebe.protocol.impl.record.value.timer.TimerRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.TimerIntent;
import io.camunda.zeebe.util.FeatureFlags;
import io.camunda.zeebe.util.sched.clock.ActorClock;
import java.time.Duration;
import java.util.function.Function;

public class DueDateTimerChecker
implements StreamProcessorLifecycleAware {
    private static final long TIMER_RESOLUTION = Duration.ofMillis(100L).toMillis();
    private static final double GIVE_YIELD_FACTOR = 0.5;
    private final DueDateChecker dueDateChecker;

    public DueDateTimerChecker(TimerInstanceState timerInstanceState, FeatureFlags featureFlags) {
        this.dueDateChecker = new DueDateChecker(TIMER_RESOLUTION, new TriggerTimersSideEffect(timerInstanceState, ActorClock.current(), featureFlags.yieldingDueDateChecker()));
    }

    public void scheduleTimer(long dueDate) {
        this.dueDateChecker.schedule(dueDate);
    }

    @Override
    public void onRecovered(ReadonlyProcessingContext context) {
        this.dueDateChecker.onRecovered(context);
    }

    @Override
    public void onClose() {
        this.dueDateChecker.onClose();
    }

    @Override
    public void onFailed() {
        this.dueDateChecker.onFailed();
    }

    @Override
    public void onPaused() {
        this.dueDateChecker.onPaused();
    }

    @Override
    public void onResumed() {
        this.dueDateChecker.onResumed();
    }

    protected static final class TriggerTimersSideEffect
    implements Function<TypedCommandWriter, Long> {
        private final ActorClock actorClock;
        private final TimerInstanceState timerInstanceState;
        private final boolean yieldControl;

        public TriggerTimersSideEffect(TimerInstanceState timerInstanceState, ActorClock actorClock, boolean yieldControl) {
            this.timerInstanceState = timerInstanceState;
            this.actorClock = actorClock;
            this.yieldControl = yieldControl;
        }

        @Override
        public Long apply(TypedCommandWriter typedCommandWriter) {
            long now = this.actorClock.getTimeMillis();
            long yieldAfter = now + Math.round((double)TIMER_RESOLUTION * 0.5);
            TimerInstanceState.TimerVisitor timerVisitor = this.yieldControl ? new YieldingDecorator(this.actorClock, yieldAfter, new WriteTriggerTimerCommandVisitor(typedCommandWriter)) : new WriteTriggerTimerCommandVisitor(typedCommandWriter);
            return this.timerInstanceState.findTimersWithDueDateBefore(now, timerVisitor);
        }
    }

    protected static final class YieldingDecorator
    implements TimerInstanceState.TimerVisitor {
        private final TimerInstanceState.TimerVisitor delegate;
        private final ActorClock actorClock;
        private final long giveYieldAfter;

        public YieldingDecorator(ActorClock actorClock, long giveYieldAfter, TimerInstanceState.TimerVisitor delegate) {
            this.delegate = delegate;
            this.actorClock = actorClock;
            this.giveYieldAfter = giveYieldAfter;
        }

        @Override
        public boolean visit(TimerInstance timer) {
            if (this.actorClock.getTimeMillis() >= this.giveYieldAfter) {
                return false;
            }
            return this.delegate.visit(timer);
        }
    }

    protected static final class WriteTriggerTimerCommandVisitor
    implements TimerInstanceState.TimerVisitor {
        private final TimerRecord timerRecord = new TimerRecord();
        private final TypedCommandWriter typedCommandWriter;

        public WriteTriggerTimerCommandVisitor(TypedCommandWriter typedCommandWriter) {
            this.typedCommandWriter = typedCommandWriter;
        }

        @Override
        public boolean visit(TimerInstance timer) {
            this.timerRecord.reset();
            this.timerRecord.setElementInstanceKey(timer.getElementInstanceKey()).setProcessInstanceKey(timer.getProcessInstanceKey()).setDueDate(timer.getDueDate()).setTargetElementId(timer.getHandlerNodeId()).setRepetitions(timer.getRepetitions()).setProcessDefinitionKey(timer.getProcessDefinitionKey());
            this.typedCommandWriter.reset();
            this.typedCommandWriter.appendFollowUpCommand(timer.getKey(), (Intent)TimerIntent.TRIGGER, (RecordValue)this.timerRecord);
            return this.typedCommandWriter.flush() > 0L;
        }
    }
}

