/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.timer;

import io.camunda.zeebe.engine.processing.common.CatchEventBehavior;
import io.camunda.zeebe.engine.processing.common.EventHandle;
import io.camunda.zeebe.engine.processing.common.EventTriggerBehavior;
import io.camunda.zeebe.engine.processing.common.ExpressionProcessor;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCatchEvent;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecord;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.sideeffect.SideEffectProducer;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedCommandWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedRejectionWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedStreamWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.KeyGenerator;
import io.camunda.zeebe.engine.state.immutable.ElementInstanceState;
import io.camunda.zeebe.engine.state.immutable.EventScopeInstanceState;
import io.camunda.zeebe.engine.state.immutable.ProcessState;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.engine.state.instance.TimerInstance;
import io.camunda.zeebe.engine.state.mutable.MutableTimerInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableZeebeState;
import io.camunda.zeebe.model.bpmn.util.time.Interval;
import io.camunda.zeebe.model.bpmn.util.time.RepeatingInterval;
import io.camunda.zeebe.model.bpmn.util.time.Timer;
import io.camunda.zeebe.protocol.impl.record.value.timer.TimerRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.TimerIntent;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class TriggerTimerProcessor
implements TypedRecordProcessor<TimerRecord> {
    private static final String NO_TIMER_FOUND_MESSAGE = "Expected to trigger timer with key '%d', but no such timer was found";
    private static final String NO_ACTIVE_TIMER_MESSAGE = "Expected to trigger a timer with key '%d', but the timer is not active anymore";
    private static final DirectBuffer NO_VARIABLES = new UnsafeBuffer();
    private final CatchEventBehavior catchEventBehavior;
    private final ProcessState processState;
    private final ElementInstanceState elementInstanceState;
    private final MutableTimerInstanceState timerInstanceState;
    private final ExpressionProcessor expressionProcessor;
    private final KeyGenerator keyGenerator;
    private final EventScopeInstanceState eventScopeInstanceState;
    private final StateWriter stateWriter;
    private final TypedRejectionWriter rejectionWriter;
    private final EventHandle eventHandle;

    public TriggerTimerProcessor(MutableZeebeState zeebeState, CatchEventBehavior catchEventBehavior, EventTriggerBehavior eventTriggerBehavior, ExpressionProcessor expressionProcessor, Writers writers) {
        this.catchEventBehavior = catchEventBehavior;
        this.expressionProcessor = expressionProcessor;
        this.stateWriter = writers.state();
        this.rejectionWriter = writers.rejection();
        this.processState = zeebeState.getProcessState();
        this.elementInstanceState = zeebeState.getElementInstanceState();
        this.timerInstanceState = zeebeState.getTimerState();
        this.keyGenerator = zeebeState.getKeyGenerator();
        this.eventScopeInstanceState = zeebeState.getEventScopeInstanceState();
        this.eventHandle = new EventHandle(this.keyGenerator, zeebeState.getEventScopeInstanceState(), writers, this.processState, eventTriggerBehavior);
    }

    @Override
    public void processRecord(TypedRecord<TimerRecord> record, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter, Consumer<SideEffectProducer> sideEffects) {
        TimerRecord timer = record.getValue();
        long elementInstanceKey = timer.getElementInstanceKey();
        long processDefinitionKey = timer.getProcessDefinitionKey();
        TimerInstance timerInstance = this.timerInstanceState.get(elementInstanceKey, record.getKey());
        if (timerInstance == null) {
            this.rejectionWriter.appendRejection(record, RejectionType.NOT_FOUND, String.format(NO_TIMER_FOUND_MESSAGE, record.getKey()));
            return;
        }
        ExecutableCatchEvent catchEvent = this.processState.getFlowElement(processDefinitionKey, timer.getTargetElementIdBuffer(), ExecutableCatchEvent.class);
        if (this.isStartEvent(elementInstanceKey)) {
            this.stateWriter.appendFollowUpEvent(record.getKey(), (Intent)TimerIntent.TRIGGERED, (RecordValue)timer);
            long processInstanceKey = this.keyGenerator.nextKey();
            this.eventHandle.activateProcessInstanceForStartEvent(processDefinitionKey, processInstanceKey, timer.getTargetElementIdBuffer(), NO_VARIABLES);
        } else {
            ElementInstance elementInstance = this.elementInstanceState.getInstance(elementInstanceKey);
            if (!this.eventHandle.canTriggerElement(elementInstance, timer.getTargetElementIdBuffer())) {
                this.rejectNoActiveTimer(record);
                return;
            }
            this.stateWriter.appendFollowUpEvent(record.getKey(), (Intent)TimerIntent.TRIGGERED, (RecordValue)timer);
            this.eventHandle.activateElement(catchEvent, elementInstanceKey, elementInstance.getValue());
        }
        if (this.shouldReschedule(timer)) {
            this.rescheduleTimer(timer, catchEvent, streamWriter, sideEffects);
        }
    }

    private void rejectNoActiveTimer(TypedRecord<TimerRecord> record) {
        this.rejectionWriter.appendRejection(record, RejectionType.INVALID_STATE, String.format(NO_ACTIVE_TIMER_MESSAGE, record.getKey()));
    }

    private boolean isStartEvent(long elementInstanceKey) {
        return elementInstanceKey < 0L;
    }

    private boolean shouldReschedule(TimerRecord timer) {
        return timer.getRepetitions() == -1 || timer.getRepetitions() > 1;
    }

    private void rescheduleTimer(TimerRecord record, ExecutableCatchEvent event, TypedCommandWriter writer, Consumer<SideEffectProducer> sideEffects) {
        Either<Failure, Timer> timer = event.getTimerFactory().apply(this.expressionProcessor, record.getElementInstanceKey());
        if (timer.isLeft()) {
            String message = String.format("Expected to reschedule repeating timer for element with id '%s', but an error occurred: %s", BufferUtil.bufferAsString((DirectBuffer)event.getId()), ((Failure)timer.getLeft()).getMessage());
            throw new IllegalStateException(message);
        }
        int repetitions = record.getRepetitions();
        if (repetitions != -1) {
            --repetitions;
        }
        Interval interval = (Interval)timer.map(Timer::getInterval).get();
        RepeatingInterval repeatingInterval = new RepeatingInterval(repetitions, interval);
        this.catchEventBehavior.subscribeToTimerEvent(record.getElementInstanceKey(), record.getProcessInstanceKey(), record.getProcessDefinitionKey(), event.getId(), (Timer)repeatingInterval, writer, sideEffects::accept);
    }
}

