/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.variable;

import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecord;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedStreamWriter;
import io.camunda.zeebe.engine.processing.variable.VariableBehavior;
import io.camunda.zeebe.engine.state.KeyGenerator;
import io.camunda.zeebe.engine.state.immutable.ElementInstanceState;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.msgpack.spec.MsgpackReaderException;
import io.camunda.zeebe.protocol.impl.record.value.variable.VariableDocumentRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.VariableDocumentIntent;
import io.camunda.zeebe.protocol.record.value.VariableDocumentUpdateSemantic;
import org.agrona.DirectBuffer;

public final class UpdateVariableDocumentProcessor
implements TypedRecordProcessor<VariableDocumentRecord> {
    private final ElementInstanceState elementInstanceState;
    private final KeyGenerator keyGenerator;
    private final VariableBehavior variableBehavior;
    private final StateWriter stateWriter;

    public UpdateVariableDocumentProcessor(ElementInstanceState elementInstanceState, KeyGenerator keyGenerator, VariableBehavior variableBehavior, StateWriter stateWriter) {
        this.elementInstanceState = elementInstanceState;
        this.keyGenerator = keyGenerator;
        this.variableBehavior = variableBehavior;
        this.stateWriter = stateWriter;
    }

    @Override
    public void processRecord(TypedRecord<VariableDocumentRecord> record, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter) {
        VariableDocumentRecord value = record.getValue();
        ElementInstance scope = this.elementInstanceState.getInstance(value.getScopeKey());
        if (scope == null || scope.isTerminating() || scope.isInFinalState()) {
            String reason = String.format("Expected to update variables for element with key '%d', but no such element was found", value.getScopeKey());
            streamWriter.appendRejection(record, RejectionType.NOT_FOUND, reason);
            responseWriter.writeRejectionOnCommand(record, RejectionType.NOT_FOUND, reason);
            return;
        }
        long processDefinitionKey = scope.getValue().getProcessDefinitionKey();
        long processInstanceKey = scope.getValue().getProcessInstanceKey();
        DirectBuffer bpmnProcessId = scope.getValue().getBpmnProcessIdBuffer();
        try {
            if (value.getUpdateSemantics() == VariableDocumentUpdateSemantic.LOCAL) {
                this.variableBehavior.mergeLocalDocument(scope.getKey(), processDefinitionKey, processInstanceKey, bpmnProcessId, value.getVariablesBuffer());
            } else {
                this.variableBehavior.mergeDocument(scope.getKey(), processDefinitionKey, processInstanceKey, bpmnProcessId, value.getVariablesBuffer());
            }
        }
        catch (MsgpackReaderException e) {
            String reason = String.format("Expected document to be valid msgpack, but it could not be read: '%s'", e.getMessage());
            streamWriter.appendRejection(record, RejectionType.INVALID_ARGUMENT, reason);
            responseWriter.writeRejectionOnCommand(record, RejectionType.INVALID_ARGUMENT, reason);
            return;
        }
        long key = this.keyGenerator.nextKey();
        this.stateWriter.appendFollowUpEvent(key, (Intent)VariableDocumentIntent.UPDATED, (RecordValue)value);
        responseWriter.writeEventOnCommand(key, (Intent)VariableDocumentIntent.UPDATED, (UnpackedObject)value, record);
    }
}

