/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.appliers;

import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCallActivity;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCatchEventElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCatchEventSupplier;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowElementContainer;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowNode;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableJobWorkerElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableMultiInstanceBody;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableSequenceFlow;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableStartEvent;
import io.camunda.zeebe.engine.state.TypedEventApplier;
import io.camunda.zeebe.engine.state.immutable.ProcessState;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.engine.state.instance.EventTrigger;
import io.camunda.zeebe.engine.state.mutable.MutableElementInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableEventScopeInstanceState;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import java.util.Collections;
import java.util.stream.IntStream;

final class ProcessInstanceElementActivatingApplier
implements TypedEventApplier<ProcessInstanceIntent, ProcessInstanceRecord> {
    private final MutableElementInstanceState elementInstanceState;
    private final ProcessState processState;
    private final MutableEventScopeInstanceState eventScopeInstanceState;

    public ProcessInstanceElementActivatingApplier(MutableElementInstanceState elementInstanceState, ProcessState processState, MutableEventScopeInstanceState eventScopeInstanceState) {
        this.elementInstanceState = elementInstanceState;
        this.processState = processState;
        this.eventScopeInstanceState = eventScopeInstanceState;
    }

    @Override
    public void applyState(long elementInstanceKey, ProcessInstanceRecord value) {
        this.createEventScope(elementInstanceKey, value);
        this.cleanupSequenceFlowsTaken(value);
        ElementInstance flowScopeInstance = this.elementInstanceState.getInstance(value.getFlowScopeKey());
        this.elementInstanceState.newInstance(flowScopeInstance, elementInstanceKey, value, ProcessInstanceIntent.ELEMENT_ACTIVATING);
        if (flowScopeInstance == null) {
            this.applyRootProcessState(elementInstanceKey, value);
            return;
        }
        BpmnElementType flowScopeElementType = flowScopeInstance.getValue().getBpmnElementType();
        BpmnElementType currentElementType = value.getBpmnElementType();
        this.decrementActiveSequenceFlow(value, flowScopeInstance, flowScopeElementType, currentElementType);
        if (currentElementType == BpmnElementType.START_EVENT && flowScopeElementType == BpmnElementType.EVENT_SUB_PROCESS) {
            EventTrigger flowScopeEventTrigger = this.eventScopeInstanceState.peekEventTrigger(flowScopeInstance.getParentKey());
            this.moveVariablesToNewEventScope(flowScopeEventTrigger, flowScopeInstance.getParentKey(), elementInstanceKey);
        }
        this.manageMultiInstanceLoopCounter(elementInstanceKey, flowScopeInstance, flowScopeElementType);
    }

    private void cleanupSequenceFlowsTaken(ProcessInstanceRecord value) {
        if (value.getBpmnElementType() != BpmnElementType.PARALLEL_GATEWAY) {
            return;
        }
        ExecutableFlowNode parallelGateway = this.processState.getFlowElement(value.getProcessDefinitionKey(), value.getElementIdBuffer(), ExecutableFlowNode.class);
        this.elementInstanceState.decrementNumberOfTakenSequenceFlows(value.getFlowScopeKey(), parallelGateway.getId());
    }

    private void moveVariablesToNewEventScope(EventTrigger eventTrigger, long oldEventScopeKey, long newEventScopeKey) {
        if (eventTrigger != null) {
            this.eventScopeInstanceState.triggerEvent(newEventScopeKey, eventTrigger.getEventKey(), eventTrigger.getElementId(), eventTrigger.getVariables());
            this.eventScopeInstanceState.deleteTrigger(oldEventScopeKey, eventTrigger.getEventKey());
        }
    }

    private void applyRootProcessState(long elementInstanceKey, ProcessInstanceRecord value) {
        BpmnElementType parentElementType;
        ElementInstance parentElementInstance = this.elementInstanceState.getInstance(value.getParentElementInstanceKey());
        if (parentElementInstance != null && (parentElementType = parentElementInstance.getValue().getBpmnElementType()) == BpmnElementType.CALL_ACTIVITY) {
            parentElementInstance.setCalledChildInstanceKey(elementInstanceKey);
            this.elementInstanceState.updateInstance(parentElementInstance);
        }
    }

    private void decrementActiveSequenceFlow(ProcessInstanceRecord value, ElementInstance flowScopeInstance, BpmnElementType flowScopeElementType, BpmnElementType currentElementType) {
        switch (currentElementType) {
            case START_EVENT: 
            case BOUNDARY_EVENT: {
                break;
            }
            case INTERMEDIATE_CATCH_EVENT: {
                this.decrementIntermediateCatchEventSequenceFlow(value, flowScopeInstance);
                break;
            }
            case PARALLEL_GATEWAY: {
                this.decrementParallelGatewaySequenceFlow(value, flowScopeInstance);
                break;
            }
            case EVENT_SUB_PROCESS: {
                this.decrementEventSubProcessSequenceFlow(value, flowScopeInstance);
                break;
            }
            default: {
                if (flowScopeElementType == BpmnElementType.MULTI_INSTANCE_BODY) break;
                flowScopeInstance.decrementActiveSequenceFlows();
                this.elementInstanceState.updateInstance(flowScopeInstance);
            }
        }
    }

    private void decrementIntermediateCatchEventSequenceFlow(ProcessInstanceRecord value, ElementInstance flowScopeInstance) {
        ExecutableCatchEventElement executableCatchEventElement = this.processState.getFlowElement(value.getProcessDefinitionKey(), value.getElementIdBuffer(), ExecutableCatchEventElement.class);
        ExecutableSequenceFlow incomingSequenceFlow = executableCatchEventElement.getIncoming().get(0);
        ExecutableFlowNode previousElement = incomingSequenceFlow.getSource();
        if (previousElement.getElementType() != BpmnElementType.EVENT_BASED_GATEWAY) {
            flowScopeInstance.decrementActiveSequenceFlows();
            this.elementInstanceState.updateInstance(flowScopeInstance);
        }
    }

    private void decrementParallelGatewaySequenceFlow(ProcessInstanceRecord value, ElementInstance flowScopeInstance) {
        ExecutableFlowNode executableFlowNode = this.processState.getFlowElement(value.getProcessDefinitionKey(), value.getElementIdBuffer(), ExecutableFlowNode.class);
        int size = executableFlowNode.getIncoming().size();
        IntStream.range(0, size).forEach(i -> flowScopeInstance.decrementActiveSequenceFlows());
        this.elementInstanceState.updateInstance(flowScopeInstance);
    }

    private void decrementEventSubProcessSequenceFlow(ProcessInstanceRecord value, ElementInstance flowScopeInstance) {
        ExecutableFlowElementContainer executableFlowElementContainer = this.getExecutableFlowElementContainer(value);
        ExecutableStartEvent executableStartEvent = executableFlowElementContainer.getStartEvents().get(0);
        if (executableStartEvent.isInterrupting()) {
            flowScopeInstance.resetActiveSequenceFlows();
        }
        this.elementInstanceState.updateInstance(flowScopeInstance);
    }

    private ExecutableFlowElementContainer getExecutableFlowElementContainer(ProcessInstanceRecord value) {
        return this.processState.getFlowElement(value.getProcessDefinitionKey(), value.getElementIdBuffer(), ExecutableFlowElementContainer.class);
    }

    private void manageMultiInstanceLoopCounter(long elementInstanceKey, ElementInstance flowScopeInstance, BpmnElementType flowScopeElementType) {
        if (flowScopeElementType == BpmnElementType.MULTI_INSTANCE_BODY) {
            flowScopeInstance.incrementMultiInstanceLoopCounter();
            this.elementInstanceState.updateInstance(flowScopeInstance);
            int loopCounter = flowScopeInstance.getMultiInstanceLoopCounter();
            this.elementInstanceState.updateInstance(elementInstanceKey, instance -> instance.setMultiInstanceLoopCounter(loopCounter));
        }
    }

    private void createEventScope(long elementInstanceKey, ProcessInstanceRecord elementRecord) {
        ExecutableFlowNode flowElement;
        Class<ExecutableFlowNode> flowElementClass = ExecutableFlowNode.class;
        if (elementRecord.getBpmnElementType() == BpmnElementType.MULTI_INSTANCE_BODY) {
            flowElementClass = ExecutableMultiInstanceBody.class;
        }
        if ((flowElement = this.processState.getFlowElement(elementRecord.getProcessDefinitionKey(), elementRecord.getElementIdBuffer(), flowElementClass)) instanceof ExecutableCatchEventSupplier) {
            boolean hasEvents;
            ExecutableCatchEventSupplier eventSupplier = (ExecutableCatchEventSupplier)((Object)flowElement);
            boolean bl = hasEvents = !eventSupplier.getEvents().isEmpty();
            if (hasEvents || flowElement instanceof ExecutableJobWorkerElement || flowElement instanceof ExecutableCallActivity) {
                this.eventScopeInstanceState.createInstance(elementInstanceKey, eventSupplier.getInterruptingElementIds(), eventSupplier.getBoundaryElementIds());
            }
        } else if (flowElement instanceof ExecutableJobWorkerElement) {
            this.eventScopeInstanceState.createInstance(elementInstanceKey, Collections.emptySet(), Collections.emptySet());
        }
    }
}

