/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine;

import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.engine.EngineContext;
import io.camunda.zeebe.engine.api.EmptyProcessingResult;
import io.camunda.zeebe.engine.api.ProcessingResult;
import io.camunda.zeebe.engine.api.ProcessingResultBuilder;
import io.camunda.zeebe.engine.api.RecordProcessor;
import io.camunda.zeebe.engine.api.TypedRecord;
import io.camunda.zeebe.engine.processing.streamprocessor.RecordProcessorMap;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessorContextImpl;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessors;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.LegacyTypedResponseWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.LegacyTypedStreamWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.EventApplier;
import io.camunda.zeebe.engine.state.ZbColumnFamilies;
import io.camunda.zeebe.engine.state.ZeebeDbState;
import io.camunda.zeebe.engine.state.processing.DbBlackListState;
import io.camunda.zeebe.logstreams.impl.Loggers;
import io.camunda.zeebe.protocol.impl.record.value.error.ErrorRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.ErrorIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRelated;
import java.util.Objects;
import java.util.function.Supplier;
import org.slf4j.Logger;

public class Engine
implements RecordProcessor<EngineContext> {
    private static final Logger LOG = Loggers.PROCESSOR_LOGGER;
    private static final String ERROR_MESSAGE_ON_EVENT_FAILED_SKIP_EVENT = "Expected to find processor for record '{}', but caught an exception. Skip this record.";
    private static final String PROCESSING_ERROR_MESSAGE = "Expected to process record '%s' without errors, but exception occurred with message '%s'.";
    private EventApplier eventApplier;
    private RecordProcessorMap recordProcessorMap;
    private ZeebeDbState zeebeState;
    private LegacyTypedStreamWriter streamWriter;
    private LegacyTypedResponseWriter responseWriter;
    private final ErrorRecord errorRecord = new ErrorRecord();
    private final ProcessingResultBuilderMutex resultBuilderMutex = new ProcessingResultBuilderMutex();
    private Writers writers;

    @Override
    public void init(EngineContext engineContext) {
        this.streamWriter = engineContext.getStreamWriterProxy();
        this.responseWriter = engineContext.getTypedResponseWriter();
        this.zeebeState = new ZeebeDbState(engineContext.getPartitionId(), (ZeebeDb<ZbColumnFamilies>)engineContext.getZeebeDb(), engineContext.getTransactionContext());
        this.eventApplier = engineContext.getEventApplierFactory().apply(this.zeebeState);
        this.writers = new Writers(this.resultBuilderMutex, this.eventApplier);
        TypedRecordProcessorContextImpl typedProcessorContext = new TypedRecordProcessorContextImpl(engineContext.getPartitionId(), engineContext.getScheduleService(), this.zeebeState, this.writers);
        TypedRecordProcessors typedRecordProcessors = engineContext.getTypedRecordProcessorFactory().createProcessors(typedProcessorContext);
        engineContext.setStreamProcessorListener(typedProcessorContext.getStreamProcessorListener());
        engineContext.setLifecycleListeners(typedRecordProcessors.getLifecycleListeners());
        this.recordProcessorMap = typedRecordProcessors.getRecordProcessorMap();
        engineContext.setWriters(this.writers);
    }

    @Override
    public void replay(TypedRecord event) {
        this.eventApplier.applyState(event.getKey(), event.getIntent(), (RecordValue)event.getValue());
    }

    @Override
    public ProcessingResult process(TypedRecord record, ProcessingResultBuilder processingResultBuilder) {
        try (ProcessingResultBuilderScope scope = new ProcessingResultBuilderScope(processingResultBuilder);){
            boolean isNotOnBlacklist;
            TypedRecordProcessor currentProcessor = null;
            TypedRecord typedCommand = record;
            try {
                currentProcessor = this.recordProcessorMap.get(typedCommand.getRecordType(), typedCommand.getValueType(), typedCommand.getIntent().value());
            }
            catch (Exception e) {
                LOG.error(ERROR_MESSAGE_ON_EVENT_FAILED_SKIP_EVENT, (Object)typedCommand, (Object)e);
            }
            if (currentProcessor == null) {
                ProcessingResult e = EmptyProcessingResult.INSTANCE;
                return e;
            }
            boolean bl = isNotOnBlacklist = !this.zeebeState.getBlackListState().isOnBlacklist(typedCommand);
            if (isNotOnBlacklist) {
                long position = typedCommand.getPosition();
                currentProcessor.processRecord(position, record, this.responseWriter, this.streamWriter, sep -> {
                    processingResultBuilder.resetPostCommitTasks();
                    processingResultBuilder.appendPostCommitTask(sep::flush);
                });
            }
        }
        return processingResultBuilder.build();
    }

    @Override
    public ProcessingResult onProcessingError(Throwable processingException, TypedRecord record, ProcessingResultBuilder processingResultBuilder) {
        String errorMessage = String.format(PROCESSING_ERROR_MESSAGE, record, processingException.getMessage());
        LOG.error(errorMessage, processingException);
        try (ProcessingResultBuilderScope scope = new ProcessingResultBuilderScope(processingResultBuilder);){
            this.writers.rejection().appendRejection(record, RejectionType.PROCESSING_ERROR, errorMessage);
            this.writers.response().writeRejectionOnCommand(record, RejectionType.PROCESSING_ERROR, errorMessage);
            this.errorRecord.initErrorRecord(processingException, record.getPosition());
            if (DbBlackListState.shouldBeBlacklisted(record.getIntent())) {
                if (record.getValue() instanceof ProcessInstanceRelated) {
                    long processInstanceKey = ((ProcessInstanceRelated)record.getValue()).getProcessInstanceKey();
                    this.errorRecord.setProcessInstanceKey(processInstanceKey);
                }
                this.writers.state().appendFollowUpEvent(record.getKey(), (Intent)ErrorIntent.CREATED, (RecordValue)this.errorRecord);
            }
        }
        return processingResultBuilder.build();
    }

    private static final class ProcessingResultBuilderMutex
    implements Supplier<ProcessingResultBuilder> {
        private ProcessingResultBuilder resultBuilder;

        private ProcessingResultBuilderMutex() {
        }

        private void setResultBuilder(ProcessingResultBuilder resultBuilder) {
            this.resultBuilder = Objects.requireNonNull(resultBuilder);
        }

        private void unsetResultBuilder() {
            this.resultBuilder = null;
        }

        @Override
        public ProcessingResultBuilder get() {
            if (this.resultBuilder == null) {
                throw new IllegalStateException("Attempt to retrieve resultBuilder out of scope.");
            }
            return this.resultBuilder;
        }
    }

    private final class ProcessingResultBuilderScope
    implements AutoCloseable {
        private ProcessingResultBuilderScope(ProcessingResultBuilder processingResultBuilder) {
            Engine.this.resultBuilderMutex.setResultBuilder(processingResultBuilder);
        }

        @Override
        public void close() {
            Engine.this.resultBuilderMutex.unsetResultBuilder();
        }
    }
}

