/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine;

import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.engine.api.ProcessingScheduleService;
import io.camunda.zeebe.engine.api.StreamProcessorLifecycleAware;
import io.camunda.zeebe.engine.processing.streamprocessor.StreamProcessorListener;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessorFactory;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.LegacyTypedResponseWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.LegacyTypedStreamWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.EventApplier;
import io.camunda.zeebe.engine.state.mutable.MutableZeebeState;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public final class EngineContext {
    private final int partitionId;
    private final ProcessingScheduleService scheduleService;
    private final ZeebeDb zeebeDb;
    private final TransactionContext transactionContext;
    private final LegacyTypedStreamWriter streamWriter;
    private final LegacyTypedResponseWriter responseWriter;
    private final Function<MutableZeebeState, EventApplier> eventApplierFactory;
    private final TypedRecordProcessorFactory typedRecordProcessorFactory;
    private List<StreamProcessorLifecycleAware> lifecycleListeners = Collections.EMPTY_LIST;
    private StreamProcessorListener streamProcessorListener;
    private Writers writers;

    public EngineContext(int partitionId, ProcessingScheduleService scheduleService, ZeebeDb zeebeDb, TransactionContext transactionContext, LegacyTypedStreamWriter streamWriter, LegacyTypedResponseWriter responseWriter, Function<MutableZeebeState, EventApplier> eventApplierFactory, TypedRecordProcessorFactory typedRecordProcessorFactory) {
        this.partitionId = partitionId;
        this.scheduleService = scheduleService;
        this.zeebeDb = zeebeDb;
        this.transactionContext = transactionContext;
        this.streamWriter = streamWriter;
        this.responseWriter = responseWriter;
        this.eventApplierFactory = eventApplierFactory;
        this.typedRecordProcessorFactory = typedRecordProcessorFactory;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public ProcessingScheduleService getScheduleService() {
        return this.scheduleService;
    }

    public ZeebeDb getZeebeDb() {
        return this.zeebeDb;
    }

    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    public LegacyTypedStreamWriter getStreamWriterProxy() {
        return this.streamWriter;
    }

    public LegacyTypedResponseWriter getTypedResponseWriter() {
        return this.responseWriter;
    }

    public Function<MutableZeebeState, EventApplier> getEventApplierFactory() {
        return this.eventApplierFactory;
    }

    public TypedRecordProcessorFactory getTypedRecordProcessorFactory() {
        return this.typedRecordProcessorFactory;
    }

    public List<StreamProcessorLifecycleAware> getLifecycleListeners() {
        return this.lifecycleListeners;
    }

    public void setLifecycleListeners(List<StreamProcessorLifecycleAware> lifecycleListeners) {
        this.lifecycleListeners = lifecycleListeners;
    }

    public StreamProcessorListener getStreamProcessorListener() {
        return this.streamProcessorListener;
    }

    public void setStreamProcessorListener(StreamProcessorListener streamProcessorListener) {
        this.streamProcessorListener = streamProcessorListener;
    }

    public Writers getWriters() {
        return this.writers;
    }

    public void setWriters(Writers writers) {
        this.writers = writers;
    }
}

