/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.behavior;

import io.camunda.zeebe.dmn.DecisionEngineFactory;
import io.camunda.zeebe.engine.metrics.JobMetrics;
import io.camunda.zeebe.engine.metrics.ProcessEngineMetrics;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContainerProcessor;
import io.camunda.zeebe.engine.processing.bpmn.ProcessInstanceStateTransitionGuard;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBufferedMessageStartEventBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnDecisionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnEventPublicationBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnEventSubscriptionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnJobBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnProcessResultSenderBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnVariableMappingBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.MultiInstanceOutputCollectionBehavior;
import io.camunda.zeebe.engine.processing.common.CatchEventBehavior;
import io.camunda.zeebe.engine.processing.common.EventTriggerBehavior;
import io.camunda.zeebe.engine.processing.common.ExpressionProcessor;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowElement;
import io.camunda.zeebe.engine.processing.streamprocessor.sideeffect.SideEffects;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedCommandWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.processing.variable.VariableBehavior;
import io.camunda.zeebe.engine.state.mutable.MutableZeebeState;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import java.util.function.Function;

public final class BpmnBehaviorsImpl
implements BpmnBehaviors {
    private final ExpressionProcessor expressionBehavior;
    private final BpmnDecisionBehavior decisionBehavior;
    private final BpmnVariableMappingBehavior variableMappingBehavior;
    private final BpmnEventPublicationBehavior eventPublicationBehavior;
    private final BpmnEventSubscriptionBehavior eventSubscriptionBehavior;
    private final BpmnIncidentBehavior incidentBehavior;
    private final BpmnStateBehavior stateBehavior;
    private final BpmnStateTransitionBehavior stateTransitionBehavior;
    private final ProcessInstanceStateTransitionGuard stateTransitionGuard;
    private final BpmnProcessResultSenderBehavior processResultSenderBehavior;
    private final BpmnBufferedMessageStartEventBehavior bufferedMessageStartEventBehavior;
    private final BpmnJobBehavior jobBehavior;
    private final MultiInstanceOutputCollectionBehavior multiInstanceOutputCollectionBehavior;

    public BpmnBehaviorsImpl(ExpressionProcessor expressionBehavior, SideEffects sideEffects, MutableZeebeState zeebeState, CatchEventBehavior catchEventBehavior, VariableBehavior variableBehavior, EventTriggerBehavior eventTriggerBehavior, Function<BpmnElementType, BpmnElementContainerProcessor<ExecutableFlowElement>> processorLookup, Writers writers, JobMetrics jobMetrics, ProcessEngineMetrics processEngineMetrics) {
        StateWriter stateWriter = writers.state();
        TypedCommandWriter commandWriter = writers.command();
        this.expressionBehavior = expressionBehavior;
        this.decisionBehavior = new BpmnDecisionBehavior(DecisionEngineFactory.createDecisionEngine(), zeebeState, eventTriggerBehavior, stateWriter, zeebeState.getKeyGenerator(), expressionBehavior, processEngineMetrics);
        this.stateBehavior = new BpmnStateBehavior(zeebeState, variableBehavior);
        this.stateTransitionGuard = new ProcessInstanceStateTransitionGuard(this.stateBehavior);
        this.variableMappingBehavior = new BpmnVariableMappingBehavior(expressionBehavior, zeebeState, variableBehavior);
        this.stateTransitionBehavior = new BpmnStateTransitionBehavior(zeebeState.getKeyGenerator(), this.stateBehavior, processEngineMetrics, processorLookup, writers);
        this.eventSubscriptionBehavior = new BpmnEventSubscriptionBehavior(catchEventBehavior, eventTriggerBehavior, commandWriter, sideEffects, zeebeState, zeebeState.getKeyGenerator());
        this.incidentBehavior = new BpmnIncidentBehavior(zeebeState, zeebeState.getKeyGenerator(), stateWriter);
        this.eventPublicationBehavior = new BpmnEventPublicationBehavior(zeebeState, zeebeState.getKeyGenerator(), eventTriggerBehavior, writers);
        this.processResultSenderBehavior = new BpmnProcessResultSenderBehavior(zeebeState, writers.response());
        this.bufferedMessageStartEventBehavior = new BpmnBufferedMessageStartEventBehavior(zeebeState, zeebeState.getKeyGenerator(), eventTriggerBehavior, writers);
        this.jobBehavior = new BpmnJobBehavior(zeebeState.getKeyGenerator(), zeebeState.getJobState(), writers, expressionBehavior, this.stateBehavior, this.incidentBehavior, jobMetrics);
        this.multiInstanceOutputCollectionBehavior = new MultiInstanceOutputCollectionBehavior(this.stateBehavior, this.expressionBehavior());
    }

    @Override
    public ExpressionProcessor expressionBehavior() {
        return this.expressionBehavior;
    }

    @Override
    public BpmnDecisionBehavior decisionBehavior() {
        return this.decisionBehavior;
    }

    @Override
    public BpmnVariableMappingBehavior variableMappingBehavior() {
        return this.variableMappingBehavior;
    }

    @Override
    public BpmnEventPublicationBehavior eventPublicationBehavior() {
        return this.eventPublicationBehavior;
    }

    @Override
    public BpmnEventSubscriptionBehavior eventSubscriptionBehavior() {
        return this.eventSubscriptionBehavior;
    }

    @Override
    public BpmnIncidentBehavior incidentBehavior() {
        return this.incidentBehavior;
    }

    @Override
    public BpmnStateBehavior stateBehavior() {
        return this.stateBehavior;
    }

    @Override
    public BpmnStateTransitionBehavior stateTransitionBehavior() {
        return this.stateTransitionBehavior;
    }

    @Override
    public ProcessInstanceStateTransitionGuard stateTransitionGuard() {
        return this.stateTransitionGuard;
    }

    @Override
    public BpmnProcessResultSenderBehavior processResultSenderBehavior() {
        return this.processResultSenderBehavior;
    }

    @Override
    public BpmnBufferedMessageStartEventBehavior bufferedMessageStartEventBehavior() {
        return this.bufferedMessageStartEventBehavior;
    }

    @Override
    public BpmnJobBehavior jobBehavior() {
        return this.jobBehavior;
    }

    @Override
    public MultiInstanceOutputCollectionBehavior outputCollectionBehavior() {
        return this.multiInstanceOutputCollectionBehavior;
    }
}

