/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.container;

import io.camunda.zeebe.el.Expression;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContainerProcessor;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnEventSubscriptionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.MultiInstanceOutputCollectionBehavior;
import io.camunda.zeebe.engine.processing.common.ExpressionProcessor;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableLoopCharacteristics;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableMultiInstanceBody;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.engine.state.instance.EventTrigger;
import io.camunda.zeebe.msgpack.spec.MsgPackHelper;
import io.camunda.zeebe.msgpack.spec.MsgPackWriter;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.List;
import java.util.Optional;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class MultiInstanceBodyProcessor
implements BpmnElementContainerProcessor<ExecutableMultiInstanceBody> {
    private static final DirectBuffer NIL_VALUE = new UnsafeBuffer(MsgPackHelper.NIL);
    private static final DirectBuffer LOOP_COUNTER_VARIABLE = BufferUtil.wrapString((String)"loopCounter");
    private final MutableDirectBuffer loopCounterVariableBuffer = new UnsafeBuffer(new byte[9]);
    private final MutableDirectBuffer numberOfInstancesVariableBuffer = new UnsafeBuffer(new byte[9]);
    private final MutableDirectBuffer numberOfActiveInstancesVariableBuffer = new UnsafeBuffer(new byte[9]);
    private final MutableDirectBuffer numberOfCompletedInstancesVariableBuffer = new UnsafeBuffer(new byte[9]);
    private final MutableDirectBuffer numberOfTerminatedInstancesVariableBuffer = new UnsafeBuffer(new byte[9]);
    private final DirectBuffer loopCounterVariableView = new UnsafeBuffer(0L, 0);
    private final DirectBuffer numberOfInstancesVariableView = new UnsafeBuffer(0L, 0);
    private final DirectBuffer numberOfActiveInstancesVariableView = new UnsafeBuffer(0L, 0);
    private final DirectBuffer numberOfCompletedInstancesVariableView = new UnsafeBuffer(0L, 0);
    private final DirectBuffer numberOfTerminatedInstancesVariableView = new UnsafeBuffer(0L, 0);
    private final MsgPackWriter variableWriter = new MsgPackWriter();
    private final ExpressionProcessor expressionBehavior;
    private final BpmnStateTransitionBehavior stateTransitionBehavior;
    private final BpmnEventSubscriptionBehavior eventSubscriptionBehavior;
    private final BpmnStateBehavior stateBehavior;
    private final BpmnIncidentBehavior incidentBehavior;
    private final MultiInstanceOutputCollectionBehavior multiInstanceOutputCollectionBehavior;

    public MultiInstanceBodyProcessor(BpmnBehaviors bpmnBehaviors) {
        this.stateTransitionBehavior = bpmnBehaviors.stateTransitionBehavior();
        this.eventSubscriptionBehavior = bpmnBehaviors.eventSubscriptionBehavior();
        this.stateBehavior = bpmnBehaviors.stateBehavior();
        this.expressionBehavior = bpmnBehaviors.expressionBehavior();
        this.incidentBehavior = bpmnBehaviors.incidentBehavior();
        this.multiInstanceOutputCollectionBehavior = bpmnBehaviors.outputCollectionBehavior();
    }

    @Override
    public Class<ExecutableMultiInstanceBody> getType() {
        return ExecutableMultiInstanceBody.class;
    }

    @Override
    public void onActivate(ExecutableMultiInstanceBody element, BpmnElementContext context) {
        this.readInputCollectionVariable(element, context).flatMap(inputCollection -> this.eventSubscriptionBehavior.subscribeToEvents(element, context).map(ok -> inputCollection)).ifRightOrLeft(inputCollection -> this.activate(element, context, (List<DirectBuffer>)inputCollection), failure -> this.incidentBehavior.createIncident((Failure)failure, context));
    }

    @Override
    public void onComplete(ExecutableMultiInstanceBody element, BpmnElementContext context) {
        this.eventSubscriptionBehavior.unsubscribeFromEvents(context);
        element.getLoopCharacteristics().getOutputCollection().ifPresent(variableName -> this.stateBehavior.propagateVariable(context, (DirectBuffer)variableName));
        this.stateTransitionBehavior.transitionToCompleted(element, context).ifRightOrLeft(completed -> this.stateTransitionBehavior.takeOutgoingSequenceFlows(element, (BpmnElementContext)completed), failure -> this.incidentBehavior.createIncident((Failure)failure, context));
    }

    @Override
    public void onTerminate(ExecutableMultiInstanceBody element, BpmnElementContext context) {
        this.eventSubscriptionBehavior.unsubscribeFromEvents(context);
        boolean noActiveChildInstances = this.stateTransitionBehavior.terminateChildInstances(context);
        if (noActiveChildInstances) {
            this.terminate(element, context);
        }
    }

    @Override
    public Either<Failure, ?> onChildActivating(ExecutableMultiInstanceBody multiInstanceBody, BpmnElementContext flowScopeContext, BpmnElementContext childContext) {
        int loopCounter = this.stateBehavior.getElementInstance(childContext).getMultiInstanceLoopCounter();
        return this.readInputCollectionVariable(multiInstanceBody, childContext).flatMap(collection -> {
            int index = loopCounter - 1;
            if (index < collection.size()) {
                DirectBuffer item = (DirectBuffer)collection.get(index);
                return Either.right((Object)item);
            }
            String incidentMessage = String.format("Expected to read item at index %d of the multiInstanceBody input collection but it contains only %d elements. The input collection might be modified while iterating over it.", index, collection.size());
            Failure failure = new Failure(incidentMessage, ErrorType.EXTRACT_VALUE_ERROR);
            return Either.left((Object)failure);
        }).map(inputElement -> {
            this.setLoopVariables(multiInstanceBody, childContext, loopCounter, (DirectBuffer)inputElement);
            return null;
        });
    }

    @Override
    public Either<Failure, ?> beforeExecutionPathCompleted(ExecutableMultiInstanceBody element, BpmnElementContext flowScopeContext, BpmnElementContext childContext) {
        Either<Failure, Void> updatedOrFailure = this.multiInstanceOutputCollectionBehavior.updateOutputCollection(element, childContext, flowScopeContext);
        if (updatedOrFailure.isLeft()) {
            return updatedOrFailure;
        }
        Either<Failure, Boolean> satisfiesCompletionConditionOrFailure = this.satisfiesCompletionCondition(element, childContext);
        if (satisfiesCompletionConditionOrFailure.isLeft()) {
            return satisfiesCompletionConditionOrFailure;
        }
        if (!element.getLoopCharacteristics().isSequential()) {
            return Either.right((Object)((Boolean)satisfiesCompletionConditionOrFailure.get()));
        }
        return this.readInputCollectionVariable(element, flowScopeContext).map(ok -> (Boolean)satisfiesCompletionConditionOrFailure.get());
    }

    @Override
    public void afterExecutionPathCompleted(ExecutableMultiInstanceBody element, BpmnElementContext flowScopeContext, BpmnElementContext childContext, Boolean satisfiesCompletionCondition) {
        boolean childInstanceCreated = false;
        ExecutableLoopCharacteristics loopCharacteristics = element.getLoopCharacteristics();
        if (satisfiesCompletionCondition.booleanValue()) {
            boolean hasNoActiveChildren = this.stateTransitionBehavior.terminateChildInstances(flowScopeContext);
            if (hasNoActiveChildren || loopCharacteristics.isSequential()) {
                this.stateTransitionBehavior.completeElement(flowScopeContext);
            }
            return;
        }
        if (loopCharacteristics.isSequential()) {
            Either<Failure, List<DirectBuffer>> inputCollectionOrFailure = this.readInputCollectionVariable(element, flowScopeContext);
            if (inputCollectionOrFailure.isLeft()) {
                this.incidentBehavior.createIncident((Failure)inputCollectionOrFailure.getLeft(), childContext);
                return;
            }
            List inputCollection = (List)inputCollectionOrFailure.get();
            int loopCounter = this.stateBehavior.getElementInstance(flowScopeContext).getMultiInstanceLoopCounter();
            if (loopCounter < inputCollection.size()) {
                this.createInnerInstance(element, flowScopeContext);
                childInstanceCreated = true;
            }
        }
        if (!childInstanceCreated && this.stateBehavior.canBeCompleted(childContext)) {
            this.stateTransitionBehavior.completeElement(flowScopeContext);
        }
    }

    @Override
    public void onChildTerminated(ExecutableMultiInstanceBody element, BpmnElementContext flowScopeContext, BpmnElementContext childContext) {
        if (flowScopeContext.getIntent() == ProcessInstanceIntent.ELEMENT_TERMINATING) {
            if (this.stateBehavior.canBeTerminated(childContext)) {
                this.terminate(element, flowScopeContext);
            }
        } else if (this.stateBehavior.canBeCompleted(childContext)) {
            this.stateTransitionBehavior.completeElement(flowScopeContext);
        }
    }

    private void activate(ExecutableMultiInstanceBody element, BpmnElementContext context, List<DirectBuffer> inputCollection) {
        BpmnElementContext activated = this.stateTransitionBehavior.transitionToActivated(context);
        ExecutableLoopCharacteristics loopCharacteristics = element.getLoopCharacteristics();
        loopCharacteristics.getOutputCollection().ifPresent(variableName -> this.multiInstanceOutputCollectionBehavior.initializeOutputCollection(activated, (DirectBuffer)variableName, inputCollection.size()));
        if (inputCollection.isEmpty()) {
            this.stateTransitionBehavior.completeElement(activated);
            return;
        }
        if (loopCharacteristics.isSequential()) {
            this.createInnerInstance(element, activated);
        } else {
            inputCollection.forEach(item -> this.createInnerInstance(element, activated));
        }
    }

    private void terminate(ExecutableMultiInstanceBody element, BpmnElementContext flowScopeContext) {
        ElementInstance flowScopeInstance = this.stateBehavior.getFlowScopeInstance(flowScopeContext);
        this.incidentBehavior.resolveIncidents(flowScopeContext);
        this.eventSubscriptionBehavior.findEventTrigger(flowScopeContext).filter(eventTrigger -> flowScopeInstance.isActive()).ifPresentOrElse(eventTrigger -> {
            BpmnElementContext terminated = this.stateTransitionBehavior.transitionToTerminated(flowScopeContext);
            this.eventSubscriptionBehavior.activateTriggeredEvent(flowScopeContext.getElementInstanceKey(), terminated.getFlowScopeKey(), (EventTrigger)((Object)eventTrigger), terminated);
            this.stateTransitionBehavior.onElementTerminated(element, terminated);
        }, () -> {
            BpmnElementContext terminated = this.stateTransitionBehavior.transitionToTerminated(flowScopeContext);
            this.stateTransitionBehavior.onElementTerminated(element, terminated);
        });
    }

    private void setLoopVariables(ExecutableMultiInstanceBody multiInstanceBody, BpmnElementContext childContext, int loopCounter, DirectBuffer inputElement) {
        ExecutableLoopCharacteristics loopCharacteristics = multiInstanceBody.getLoopCharacteristics();
        loopCharacteristics.getInputElement().ifPresent(variableName -> this.stateBehavior.setLocalVariable(childContext, (DirectBuffer)variableName, inputElement));
        loopCharacteristics.getOutputElement().flatMap(Expression::getVariableName).map(BufferUtil::wrapString).ifPresent(variableName -> this.stateBehavior.setLocalVariable(childContext, (DirectBuffer)variableName, NIL_VALUE));
        this.stateBehavior.setLocalVariable(childContext, LOOP_COUNTER_VARIABLE, this.wrapVariable(this.loopCounterVariableBuffer, this.loopCounterVariableView, loopCounter));
    }

    private Either<Failure, List<DirectBuffer>> readInputCollectionVariable(ExecutableMultiInstanceBody element, BpmnElementContext context) {
        Expression inputCollection = element.getLoopCharacteristics().getInputCollection();
        return this.expressionBehavior.evaluateArrayExpression(inputCollection, context.getElementInstanceKey());
    }

    private void createInnerInstance(ExecutableMultiInstanceBody multiInstanceBody, BpmnElementContext context) {
        this.stateTransitionBehavior.activateChildInstanceWithKey(context, multiInstanceBody.getInnerActivity());
    }

    private DirectBuffer wrapVariable(MutableDirectBuffer variableBuffer, DirectBuffer variableView, long value) {
        this.variableWriter.wrap(variableBuffer, 0);
        this.variableWriter.writeInteger(value);
        int length = this.variableWriter.getOffset();
        variableView.wrap((DirectBuffer)variableBuffer, 0, length);
        return variableView;
    }

    private Either<Failure, Boolean> satisfiesCompletionCondition(ExecutableMultiInstanceBody element, BpmnElementContext context) {
        Optional<Expression> completionCondition = element.getLoopCharacteristics().getCompletionCondition();
        ExpressionProcessor primaryContextExpressionProcessor = this.expressionBehavior.withPrimaryContext(variableName -> this.getVariable(context.getFlowScopeKey(), variableName));
        if (completionCondition.isPresent()) {
            return primaryContextExpressionProcessor.evaluateBooleanExpression(completionCondition.get(), context.getElementInstanceKey());
        }
        return Either.right((Object)false);
    }

    private DirectBuffer getVariable(long elementInstanceKey, String variableName) {
        return switch (variableName) {
            case "numberOfInstances" -> this.getNumberOfInstancesVariable(elementInstanceKey);
            case "numberOfActiveInstances" -> this.getNumberOfActiveInstancesVariable(elementInstanceKey);
            case "numberOfCompletedInstances" -> this.getNumberOfCompletedInstancesVariable(elementInstanceKey);
            case "numberOfTerminatedInstances" -> this.getNumberOfTerminatedInstancesVariable(elementInstanceKey);
            default -> null;
        };
    }

    private DirectBuffer getNumberOfInstancesVariable(long elementInstanceKey) {
        return this.wrapVariable(this.numberOfInstancesVariableBuffer, this.numberOfInstancesVariableView, this.stateBehavior.getElementInstance(elementInstanceKey).getNumberOfElementInstances());
    }

    private DirectBuffer getNumberOfActiveInstancesVariable(long elementInstanceKey) {
        int numberOfActiveInstances = this.stateBehavior.getElementInstance(elementInstanceKey).getNumberOfActiveElementInstances() - 1;
        return this.wrapVariable(this.numberOfActiveInstancesVariableBuffer, this.numberOfActiveInstancesVariableView, numberOfActiveInstances);
    }

    private DirectBuffer getNumberOfCompletedInstancesVariable(long elementInstanceKey) {
        int numberOfCompletedInstances = this.stateBehavior.getElementInstance(elementInstanceKey).getNumberOfCompletedElementInstances() + 1;
        return this.wrapVariable(this.numberOfCompletedInstancesVariableBuffer, this.numberOfCompletedInstancesVariableView, numberOfCompletedInstances);
    }

    private DirectBuffer getNumberOfTerminatedInstancesVariable(long elementInstanceKey) {
        int numberOfTerminatedInstances = this.stateBehavior.getElementInstance(elementInstanceKey).getNumberOfTerminatedElementInstances();
        return this.wrapVariable(this.numberOfTerminatedInstancesVariableBuffer, this.numberOfTerminatedInstancesVariableView, numberOfTerminatedInstances);
    }
}

