/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.container;

import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContainerProcessor;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.BpmnProcessingException;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBufferedMessageStartEventBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnEventSubscriptionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnProcessResultSenderBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowElementContainer;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableStartEvent;
import io.camunda.zeebe.engine.state.instance.EventTrigger;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.util.Either;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.agrona.DirectBuffer;

public final class ProcessProcessor
implements BpmnElementContainerProcessor<ExecutableFlowElementContainer> {
    private static final Consumer<BpmnElementContext> NOOP = context -> {};
    private final BpmnStateBehavior stateBehavior;
    private final BpmnStateTransitionBehavior stateTransitionBehavior;
    private final BpmnEventSubscriptionBehavior eventSubscriptionBehavior;
    private final BpmnIncidentBehavior incidentBehavior;
    private final BpmnProcessResultSenderBehavior processResultSenderBehavior;
    private final BpmnBufferedMessageStartEventBehavior bufferedMessageStartEventBehavior;

    public ProcessProcessor(BpmnBehaviors bpmnBehaviors) {
        this.stateBehavior = bpmnBehaviors.stateBehavior();
        this.stateTransitionBehavior = bpmnBehaviors.stateTransitionBehavior();
        this.eventSubscriptionBehavior = bpmnBehaviors.eventSubscriptionBehavior();
        this.incidentBehavior = bpmnBehaviors.incidentBehavior();
        this.processResultSenderBehavior = bpmnBehaviors.processResultSenderBehavior();
        this.bufferedMessageStartEventBehavior = bpmnBehaviors.bufferedMessageStartEventBehavior();
    }

    @Override
    public Class<ExecutableFlowElementContainer> getType() {
        return ExecutableFlowElementContainer.class;
    }

    @Override
    public void onActivate(ExecutableFlowElementContainer element, BpmnElementContext context) {
        BpmnElementContext activatedContext = this.stateTransitionBehavior.transitionToActivated(context);
        this.activateStartEvent(element, activatedContext);
    }

    @Override
    public void onComplete(ExecutableFlowElementContainer element, BpmnElementContext context) {
        this.eventSubscriptionBehavior.unsubscribeFromEvents(context);
        this.processResultSenderBehavior.sendResult(context);
        this.transitionTo(element, context, completing -> this.stateTransitionBehavior.transitionToCompleted(element, (BpmnElementContext)completing));
    }

    @Override
    public void onTerminate(ExecutableFlowElementContainer element, BpmnElementContext context) {
        this.eventSubscriptionBehavior.unsubscribeFromEvents(context);
        this.incidentBehavior.resolveIncidents(context);
        boolean noActiveChildInstances = this.stateTransitionBehavior.terminateChildInstances(context);
        if (noActiveChildInstances) {
            this.transitionTo(element, context, terminating -> Either.right((Object)this.stateTransitionBehavior.transitionToTerminated((BpmnElementContext)terminating)));
        }
    }

    private void activateStartEvent(ExecutableFlowElementContainer element, BpmnElementContext activated) {
        if (element.hasMessageStartEvent() || element.hasTimerStartEvent()) {
            this.eventSubscriptionBehavior.getEventTriggerForProcessDefinition(activated.getProcessDefinitionKey()).ifPresentOrElse(eventTrigger -> this.eventSubscriptionBehavior.activateTriggeredStartEvent(activated, (EventTrigger)((Object)eventTrigger)), () -> this.activateNoneStartEvent(element, activated));
        } else {
            this.activateNoneStartEvent(element, activated);
        }
    }

    private void activateNoneStartEvent(ExecutableFlowElementContainer element, BpmnElementContext context) {
        ExecutableStartEvent noneStartEvent = element.getNoneStartEvent();
        if (noneStartEvent == null) {
            throw new BpmnProcessingException(context, "Expected to activate the none start event of the process but not found.");
        }
        this.stateTransitionBehavior.activateChildInstance(context, noneStartEvent);
    }

    @Override
    public void afterExecutionPathCompleted(ExecutableFlowElementContainer element, BpmnElementContext flowScopeContext, BpmnElementContext childContext, Boolean satisfiesCompletionCondition) {
        if (this.stateBehavior.canBeCompleted(childContext)) {
            this.stateTransitionBehavior.completeElement(flowScopeContext);
        }
    }

    @Override
    public void onChildTerminated(ExecutableFlowElementContainer element, BpmnElementContext flowScopeContext, BpmnElementContext childContext) {
        if (this.stateBehavior.isInterrupted(flowScopeContext)) {
            this.eventSubscriptionBehavior.findEventTrigger(flowScopeContext).ifPresent(eventTrigger -> this.eventSubscriptionBehavior.activateTriggeredEvent(flowScopeContext.getElementInstanceKey(), flowScopeContext.getElementInstanceKey(), (EventTrigger)((Object)eventTrigger), flowScopeContext));
        } else if (this.stateBehavior.canBeTerminated(childContext)) {
            this.transitionTo(element, flowScopeContext, context -> Either.right((Object)this.stateTransitionBehavior.transitionToTerminated((BpmnElementContext)context)));
        }
    }

    private void transitionTo(ExecutableFlowElementContainer element, BpmnElementContext context, Function<BpmnElementContext, Either<Failure, BpmnElementContext>> transitionOperation) {
        Consumer<BpmnElementContext> postTransitionAction = this.getPostTransitionAction(element, context);
        Either<Failure, BpmnElementContext> afterTransition = transitionOperation.apply(context);
        afterTransition.ifRightOrLeft(postTransitionAction, failure -> this.incidentBehavior.createIncident((Failure)failure, context));
    }

    private Consumer<BpmnElementContext> getPostTransitionAction(ExecutableFlowElementContainer processElement, BpmnElementContext context) {
        long parentProcessInstanceKey = context.getParentProcessInstanceKey();
        if (parentProcessInstanceKey > 0L) {
            BpmnElementContext parentInstanceContext = this.stateBehavior.getParentElementInstanceContext(context);
            return postTransitionContext -> {
                if (postTransitionContext.getIntent() == ProcessInstanceIntent.ELEMENT_COMPLETED) {
                    this.stateTransitionBehavior.onCalledProcessCompleted((BpmnElementContext)postTransitionContext, parentInstanceContext);
                } else {
                    this.stateTransitionBehavior.onCalledProcessTerminated((BpmnElementContext)postTransitionContext, parentInstanceContext);
                }
            };
        }
        if (processElement.hasMessageStartEvent()) {
            Optional<DirectBuffer> correlationKey = this.bufferedMessageStartEventBehavior.findCorrelationKey(context);
            return postTransitionContext -> correlationKey.ifPresent(key -> this.bufferedMessageStartEventBehavior.correlateMessage((BpmnElementContext)postTransitionContext, (DirectBuffer)key));
        }
        return NOOP;
    }
}

