/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.job;

import io.camunda.zeebe.engine.api.ReadonlyStreamProcessorContext;
import io.camunda.zeebe.engine.api.StreamProcessorLifecycleAware;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.LegacyTypedCommandWriter;
import io.camunda.zeebe.engine.state.immutable.JobState;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.scheduler.clock.ActorClock;
import java.time.Duration;

public final class JobTimeoutTrigger
implements StreamProcessorLifecycleAware {
    public static final Duration TIME_OUT_POLLING_INTERVAL = Duration.ofSeconds(30L);
    private final JobState state;
    private boolean shouldReschedule = false;
    private LegacyTypedCommandWriter writer;
    private ReadonlyStreamProcessorContext processingContext;

    public JobTimeoutTrigger(JobState state) {
        this.state = state;
    }

    @Override
    public void onRecovered(ReadonlyStreamProcessorContext processingContext) {
        this.processingContext = processingContext;
        this.shouldReschedule = true;
        this.scheduleDeactivateTimedOutJobsTask();
        this.writer = processingContext.getLogStreamWriter();
    }

    @Override
    public void onClose() {
        this.cancelTimer();
    }

    @Override
    public void onFailed() {
        this.cancelTimer();
    }

    @Override
    public void onPaused() {
        this.cancelTimer();
    }

    @Override
    public void onResumed() {
        if (this.shouldReschedule) {
            this.scheduleDeactivateTimedOutJobsTask();
        }
    }

    private void scheduleDeactivateTimedOutJobsTask() {
        this.processingContext.getScheduleService().runDelayed(TIME_OUT_POLLING_INTERVAL, this::deactivateTimedOutJobs);
    }

    private void cancelTimer() {
        this.shouldReschedule = false;
    }

    void deactivateTimedOutJobs() {
        long now = ActorClock.currentTimeMillis();
        this.state.forEachTimedOutEntry(now, (key, record) -> {
            this.writer.reset();
            this.writer.appendFollowUpCommand((long)key, (Intent)JobIntent.TIME_OUT, (RecordValue)record);
            return this.writer.flush() >= 0L;
        });
        if (this.shouldReschedule) {
            this.scheduleDeactivateTimedOutJobsTask();
        }
    }
}

