/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.message;

import io.camunda.zeebe.engine.api.TypedRecord;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.LegacyTypedResponseWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.LegacyTypedStreamWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedRejectionWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.immutable.ProcessMessageSubscriptionState;
import io.camunda.zeebe.engine.state.message.ProcessMessageSubscription;
import io.camunda.zeebe.protocol.impl.record.value.message.ProcessMessageSubscriptionRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessMessageSubscriptionIntent;
import io.camunda.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;

public final class ProcessMessageSubscriptionCreateProcessor
implements TypedRecordProcessor<ProcessMessageSubscriptionRecord> {
    private static final String NO_SUBSCRIPTION_FOUND_MESSAGE = "Expected to create process message subscription with element key '%d' and message name '%s', but no such subscription was found";
    private static final String NOT_OPENING_MSG = "Expected to create process message subscription with element key '%d' and message name '%s', but it is already %s";
    private final ProcessMessageSubscriptionState subscriptionState;
    private final StateWriter stateWriter;
    private final TypedRejectionWriter rejectionWriter;

    public ProcessMessageSubscriptionCreateProcessor(ProcessMessageSubscriptionState subscriptionState, Writers writers) {
        this.subscriptionState = subscriptionState;
        this.stateWriter = writers.state();
        this.rejectionWriter = writers.rejection();
    }

    @Override
    public void processRecord(TypedRecord<ProcessMessageSubscriptionRecord> command, LegacyTypedResponseWriter responseWriter, LegacyTypedStreamWriter streamWriter) {
        ProcessMessageSubscriptionRecord subscriptionRecord = command.getValue();
        ProcessMessageSubscription subscription = this.subscriptionState.getSubscription(subscriptionRecord.getElementInstanceKey(), subscriptionRecord.getMessageNameBuffer());
        if (subscription != null && subscription.isOpening()) {
            this.stateWriter.appendFollowUpEvent(subscription.getKey(), (Intent)ProcessMessageSubscriptionIntent.CREATED, (RecordValue)subscription.getRecord());
        } else {
            this.rejectCommand(command, subscription);
        }
    }

    private void rejectCommand(TypedRecord<ProcessMessageSubscriptionRecord> command, ProcessMessageSubscription subscription) {
        ProcessMessageSubscriptionRecord record = command.getValue();
        long elementInstanceKey = record.getElementInstanceKey();
        String messageName = BufferUtil.bufferAsString((DirectBuffer)record.getMessageNameBuffer());
        if (subscription == null) {
            String reason = String.format(NO_SUBSCRIPTION_FOUND_MESSAGE, elementInstanceKey, messageName);
            this.rejectionWriter.appendRejection(command, RejectionType.NOT_FOUND, reason);
        } else {
            String state = subscription.isClosing() ? "closing" : "opened";
            String reason = String.format(NOT_OPENING_MSG, elementInstanceKey, messageName, state);
            this.rejectionWriter.appendRejection(command, RejectionType.INVALID_STATE, reason);
        }
    }
}

