/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.processinstance;

import io.camunda.zeebe.engine.api.TypedRecord;
import io.camunda.zeebe.engine.metrics.ProcessEngineMetrics;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContextImpl;
import io.camunda.zeebe.engine.processing.common.CatchEventBehavior;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.AbstractFlowElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCatchEventSupplier;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowNode;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableProcess;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableSequenceFlow;
import io.camunda.zeebe.engine.processing.streamprocessor.CommandProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.sideeffect.SideEffectQueue;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedCommandWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.processing.variable.VariableBehavior;
import io.camunda.zeebe.engine.state.KeyGenerator;
import io.camunda.zeebe.engine.state.deployment.DeployedProcess;
import io.camunda.zeebe.engine.state.immutable.ProcessState;
import io.camunda.zeebe.msgpack.property.ArrayProperty;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceCreationRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceCreationStartInstruction;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceCreationIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferUtil;
import io.camunda.zeebe.util.exception.UncheckedExecutionException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.agrona.DirectBuffer;

public final class CreateProcessInstanceProcessor
implements CommandProcessor<ProcessInstanceCreationRecord> {
    private static final String ERROR_MESSAGE_NO_IDENTIFIER_SPECIFIED = "Expected at least a bpmnProcessId or a key greater than -1, but none given";
    private static final String ERROR_MESSAGE_NOT_FOUND_BY_PROCESS = "Expected to find process definition with process ID '%s', but none found";
    private static final String ERROR_MESSAGE_NOT_FOUND_BY_PROCESS_AND_VERSION = "Expected to find process definition with process ID '%s' and version '%d', but none found";
    private static final String ERROR_MESSAGE_NOT_FOUND_BY_KEY = "Expected to find process definition with key '%d', but none found";
    private static final String ERROR_MESSAGE_NO_NONE_START_EVENT = "Expected to create instance of process with none start event, but there is no such event";
    private static final Either<Rejection, Object> VALID = Either.right(null);
    private static final Set<BpmnElementType> UNSUPPORTED_ELEMENT_TYPES = Set.of(BpmnElementType.START_EVENT, BpmnElementType.SEQUENCE_FLOW, BpmnElementType.BOUNDARY_EVENT, BpmnElementType.UNSPECIFIED);
    private final ProcessInstanceRecord newProcessInstance = new ProcessInstanceRecord();
    private final SideEffectQueue sideEffectQueue = new SideEffectQueue();
    private final ProcessState processState;
    private final VariableBehavior variableBehavior;
    private final CatchEventBehavior catchEventBehavior;
    private final KeyGenerator keyGenerator;
    private final TypedCommandWriter commandWriter;
    private final StateWriter stateWriter;
    private final ProcessEngineMetrics metrics;

    public CreateProcessInstanceProcessor(ProcessState processState, KeyGenerator keyGenerator, Writers writers, VariableBehavior variableBehavior, CatchEventBehavior catchEventBehavior, ProcessEngineMetrics metrics) {
        this.processState = processState;
        this.variableBehavior = variableBehavior;
        this.catchEventBehavior = catchEventBehavior;
        this.keyGenerator = keyGenerator;
        this.commandWriter = writers.command();
        this.stateWriter = writers.state();
        this.metrics = metrics;
    }

    @Override
    public boolean onCommand(TypedRecord<ProcessInstanceCreationRecord> command, CommandProcessor.CommandControl<ProcessInstanceCreationRecord> controller) {
        this.sideEffectQueue.clear();
        ProcessInstanceCreationRecord record = command.getValue();
        this.getProcess(record).flatMap(process -> this.validateCommand((ProcessInstanceCreationRecord)command.getValue(), (DeployedProcess)process)).ifRightOrLeft(process -> this.createProcessInstance(controller, record, (DeployedProcess)process), rejection -> controller.reject(rejection.type, rejection.reason));
        return true;
    }

    private void createProcessInstance(CommandProcessor.CommandControl<ProcessInstanceCreationRecord> controller, ProcessInstanceCreationRecord record, DeployedProcess process) {
        long processInstanceKey = this.keyGenerator.nextKey();
        this.setVariablesFromDocument(record, process.getKey(), processInstanceKey, process.getBpmnProcessId());
        ProcessInstanceRecord processInstance = this.initProcessInstanceRecord(process, processInstanceKey);
        if (record.startInstructions().isEmpty()) {
            this.commandWriter.appendFollowUpCommand(processInstanceKey, (Intent)ProcessInstanceIntent.ACTIVATE_ELEMENT, (RecordValue)processInstance);
        } else {
            this.activateElementsForStartInstructions((ArrayProperty<ProcessInstanceCreationStartInstruction>)record.startInstructions(), process, processInstanceKey, processInstance);
        }
        record.setProcessInstanceKey(processInstanceKey).setBpmnProcessId(process.getBpmnProcessId()).setVersion(process.getVersion()).setProcessDefinitionKey(process.getKey());
        controller.accept((Intent)ProcessInstanceCreationIntent.CREATED, record);
        this.metrics.processInstanceCreated(record);
    }

    private Either<Rejection, DeployedProcess> validateCommand(ProcessInstanceCreationRecord command, DeployedProcess deployedProcess) {
        ExecutableProcess process = deployedProcess.getProcess();
        ArrayProperty startInstructions = command.startInstructions();
        return this.validateHasNoneStartEventOrStartInstructions(process, (ArrayProperty<ProcessInstanceCreationStartInstruction>)startInstructions).flatMap(valid -> this.validateElementsExist(process, (ArrayProperty<ProcessInstanceCreationStartInstruction>)startInstructions)).flatMap(valid -> this.validateElementsNotInsideMultiInstance(process, (ArrayProperty<ProcessInstanceCreationStartInstruction>)startInstructions)).flatMap(valid -> this.validateTargetsSupportedElementType(process, (ArrayProperty<ProcessInstanceCreationStartInstruction>)startInstructions)).flatMap(valid -> this.validateElementNotBelongingToEventBasedGateway(process, (ArrayProperty<ProcessInstanceCreationStartInstruction>)startInstructions)).map(valid -> deployedProcess);
    }

    private Either<Rejection, ?> validateHasNoneStartEventOrStartInstructions(ExecutableProcess process, ArrayProperty<ProcessInstanceCreationStartInstruction> startInstructions) {
        if (process.getNoneStartEvent() != null || !startInstructions.isEmpty()) {
            return VALID;
        }
        return Either.left((Object)new Rejection(RejectionType.INVALID_STATE, ERROR_MESSAGE_NO_NONE_START_EVENT));
    }

    private Either<Rejection, ?> validateElementsExist(ExecutableProcess process, ArrayProperty<ProcessInstanceCreationStartInstruction> startInstructions) {
        return startInstructions.stream().map(ProcessInstanceCreationStartInstruction::getElementId).filter(elementId -> !this.isElementOfProcess(process, (String)elementId)).findAny().map(elementId -> Either.left((Object)new Rejection(RejectionType.INVALID_ARGUMENT, "Expected to create instance of process with start instructions but no element found with id '%s'.".formatted(elementId)))).orElse(VALID);
    }

    private boolean isElementOfProcess(ExecutableProcess process, String elementId) {
        return process.getElementById(BufferUtil.wrapString((String)elementId)) != null;
    }

    private Either<Rejection, ?> validateElementsNotInsideMultiInstance(ExecutableProcess process, ArrayProperty<ProcessInstanceCreationStartInstruction> startInstructions) {
        return startInstructions.stream().map(ProcessInstanceCreationStartInstruction::getElementId).filter(elementId -> this.isElementInsideMultiInstance(process, (String)elementId)).findAny().map(elementId -> Either.left((Object)new Rejection(RejectionType.INVALID_ARGUMENT, "Expected to create instance of process with start instructions but the element with id '%s' is inside a multi-instance subprocess. The creation of elements inside a multi-instance subprocess is not supported.".formatted(elementId)))).orElse(VALID);
    }

    private boolean isElementInsideMultiInstance(ExecutableProcess process, String elementId) {
        AbstractFlowElement element = process.getElementById(BufferUtil.wrapString((String)elementId));
        return element != null && this.hasMultiInstanceScope(element);
    }

    private boolean hasMultiInstanceScope(ExecutableFlowElement flowElement) {
        ExecutableFlowElement flowScope = flowElement.getFlowScope();
        if (flowScope == null) {
            return false;
        }
        if (flowScope.getElementType() == BpmnElementType.MULTI_INSTANCE_BODY) {
            return true;
        }
        return this.hasMultiInstanceScope(flowScope);
    }

    private Either<Rejection, ?> validateTargetsSupportedElementType(ExecutableProcess process, ArrayProperty<ProcessInstanceCreationStartInstruction> startInstructions) {
        return startInstructions.stream().map(instruction -> new ElementIdAndType(instruction.getElementId(), process.getElementById(instruction.getElementIdBuffer()).getElementType())).filter(elementIdAndType -> UNSUPPORTED_ELEMENT_TYPES.contains(elementIdAndType.elementType)).findAny().map(elementIdAndType -> Either.left((Object)new Rejection(RejectionType.INVALID_ARGUMENT, "Expected to create instance of process with start instructions but the element with id '%s' targets unsupported element type '%s'. Supported element types are: %s".formatted(elementIdAndType.elementId, elementIdAndType.elementType, Arrays.stream(BpmnElementType.values()).filter(elementType -> !UNSUPPORTED_ELEMENT_TYPES.contains(elementType)).collect(Collectors.toSet()))))).orElse(VALID);
    }

    private Either<Rejection, ?> validateElementNotBelongingToEventBasedGateway(ExecutableProcess process, ArrayProperty<ProcessInstanceCreationStartInstruction> startInstructions) {
        return startInstructions.stream().map(ProcessInstanceCreationStartInstruction::getElementId).filter(elementId -> this.doesElementBelongToAnEventBasedGateway(process, (String)elementId)).findAny().map(elementId -> Either.left((Object)new Rejection(RejectionType.INVALID_ARGUMENT, "Expected to create instance of process with start instructions but the element with id '%s' belongs to an event-based gateway. The creation of elements belonging to an event-based gateway is not supported.".formatted(elementId)))).orElse(VALID);
    }

    private boolean doesElementBelongToAnEventBasedGateway(ExecutableProcess process, String elementId) {
        ExecutableFlowNode element = process.getElementById(elementId, ExecutableFlowNode.class);
        return element.getIncoming().stream().map(ExecutableSequenceFlow::getSource).anyMatch(flowNode -> flowNode.getElementType().equals((Object)BpmnElementType.EVENT_BASED_GATEWAY));
    }

    private void setVariablesFromDocument(ProcessInstanceCreationRecord record, long processDefinitionKey, long processInstanceKey, DirectBuffer bpmnProcessId) {
        this.variableBehavior.mergeLocalDocument(processInstanceKey, processDefinitionKey, processInstanceKey, bpmnProcessId, record.getVariablesBuffer());
    }

    private ProcessInstanceRecord initProcessInstanceRecord(DeployedProcess process, long processInstanceKey) {
        this.newProcessInstance.reset();
        this.newProcessInstance.setBpmnProcessId(process.getBpmnProcessId());
        this.newProcessInstance.setVersion(process.getVersion());
        this.newProcessInstance.setProcessDefinitionKey(process.getKey());
        this.newProcessInstance.setProcessInstanceKey(processInstanceKey);
        this.newProcessInstance.setBpmnElementType(BpmnElementType.PROCESS);
        this.newProcessInstance.setElementId(process.getProcess().getId());
        this.newProcessInstance.setFlowScopeKey(-1L);
        return this.newProcessInstance;
    }

    private Either<Rejection, DeployedProcess> getProcess(ProcessInstanceCreationRecord record) {
        DirectBuffer bpmnProcessId = record.getBpmnProcessIdBuffer();
        if (bpmnProcessId.capacity() > 0) {
            if (record.getVersion() >= 0) {
                return this.getProcess(bpmnProcessId, record.getVersion());
            }
            return this.getProcess(bpmnProcessId);
        }
        if (record.getProcessDefinitionKey() >= 0L) {
            return this.getProcess(record.getProcessDefinitionKey());
        }
        return Either.left((Object)new Rejection(RejectionType.INVALID_ARGUMENT, ERROR_MESSAGE_NO_IDENTIFIER_SPECIFIED));
    }

    private Either<Rejection, DeployedProcess> getProcess(DirectBuffer bpmnProcessId) {
        DeployedProcess process = this.processState.getLatestProcessVersionByProcessId(bpmnProcessId);
        if (process != null) {
            return Either.right((Object)process);
        }
        return Either.left((Object)new Rejection(RejectionType.NOT_FOUND, String.format(ERROR_MESSAGE_NOT_FOUND_BY_PROCESS, BufferUtil.bufferAsString((DirectBuffer)bpmnProcessId))));
    }

    private Either<Rejection, DeployedProcess> getProcess(DirectBuffer bpmnProcessId, int version) {
        DeployedProcess process = this.processState.getProcessByProcessIdAndVersion(bpmnProcessId, version);
        if (process != null) {
            return Either.right((Object)process);
        }
        return Either.left((Object)new Rejection(RejectionType.NOT_FOUND, String.format(ERROR_MESSAGE_NOT_FOUND_BY_PROCESS_AND_VERSION, BufferUtil.bufferAsString((DirectBuffer)bpmnProcessId), version)));
    }

    private Either<Rejection, DeployedProcess> getProcess(long key) {
        DeployedProcess process = this.processState.getProcessByKey(key);
        if (process != null) {
            return Either.right((Object)process);
        }
        return Either.left((Object)new Rejection(RejectionType.NOT_FOUND, String.format(ERROR_MESSAGE_NOT_FOUND_BY_KEY, key)));
    }

    private void activateElementsForStartInstructions(ArrayProperty<ProcessInstanceCreationStartInstruction> startInstructions, DeployedProcess process, long processInstanceKey, ProcessInstanceRecord processInstance) {
        this.activateElementInstance(process.getProcess(), processInstanceKey, processInstance);
        HashMap<DirectBuffer, Long> activatedFlowScopeIds = new HashMap<DirectBuffer, Long>();
        activatedFlowScopeIds.put(processInstance.getElementIdBuffer(), processInstanceKey);
        startInstructions.forEach(instruction -> {
            DirectBuffer elementId = BufferUtil.wrapString((String)instruction.getElementId());
            long flowScopeKey = this.activateFlowScopes(process, processInstanceKey, elementId, activatedFlowScopeIds);
            long elementInstanceKey = this.keyGenerator.nextKey();
            ProcessInstanceRecord elementRecord = this.createProcessInstanceRecord(process, processInstanceKey, elementId, flowScopeKey);
            this.commandWriter.appendFollowUpCommand(elementInstanceKey, (Intent)ProcessInstanceIntent.ACTIVATE_ELEMENT, (RecordValue)elementRecord);
        });
        this.sideEffectQueue.flush();
    }

    private long activateFlowScopes(DeployedProcess process, long processInstanceKey, DirectBuffer elementId, Map<DirectBuffer, Long> activatedFlowScopeIds) {
        ExecutableFlowElement flowScope = process.getProcess().getElementById(elementId).getFlowScope();
        if (activatedFlowScopeIds.containsKey(flowScope.getId())) {
            return activatedFlowScopeIds.get(flowScope.getId());
        }
        long flowScopeKey = this.activateFlowScopes(process, processInstanceKey, flowScope.getId(), activatedFlowScopeIds);
        ProcessInstanceRecord flowScopeRecord = this.createProcessInstanceRecord(process, processInstanceKey, flowScope.getId(), flowScopeKey);
        long elementInstanceKey = this.keyGenerator.nextKey();
        activatedFlowScopeIds.put(flowScope.getId(), elementInstanceKey);
        this.activateElementInstance(flowScope, elementInstanceKey, flowScopeRecord);
        return elementInstanceKey;
    }

    private void activateElementInstance(ExecutableFlowElement element, long elementInstanceKey, ProcessInstanceRecord elementRecord) {
        this.stateWriter.appendFollowUpEvent(elementInstanceKey, (Intent)ProcessInstanceIntent.ELEMENT_ACTIVATING, (RecordValue)elementRecord);
        this.stateWriter.appendFollowUpEvent(elementInstanceKey, (Intent)ProcessInstanceIntent.ELEMENT_ACTIVATED, (RecordValue)elementRecord);
        this.createEventSubscriptions(element, elementRecord, elementInstanceKey);
    }

    private void createEventSubscriptions(ExecutableFlowElement element, ProcessInstanceRecord elementRecord, long elementInstanceKey) {
        if (element instanceof ExecutableCatchEventSupplier) {
            ExecutableCatchEventSupplier catchEventSupplier = (ExecutableCatchEventSupplier)element;
            BpmnElementContextImpl bpmnElementContext = new BpmnElementContextImpl();
            bpmnElementContext.init(elementInstanceKey, elementRecord, ProcessInstanceIntent.ELEMENT_ACTIVATED);
            Either<Failure, Void> subscribedOrFailure = this.catchEventBehavior.subscribeToEvents(bpmnElementContext, catchEventSupplier, this.sideEffectQueue, this.commandWriter);
            if (subscribedOrFailure.isLeft()) {
                String message = "expected to subscribe to catch event(s) of '%s' but %s".formatted(BufferUtil.bufferAsString((DirectBuffer)element.getId()), ((Failure)subscribedOrFailure.getLeft()).getMessage());
                throw new UncheckedExecutionException(message);
            }
        }
    }

    private ProcessInstanceRecord createProcessInstanceRecord(DeployedProcess process, long processInstanceKey, DirectBuffer elementId, long flowScopeKey) {
        ProcessInstanceRecord record = new ProcessInstanceRecord();
        record.setBpmnProcessId(process.getBpmnProcessId());
        record.setVersion(process.getVersion());
        record.setProcessDefinitionKey(process.getKey());
        record.setProcessInstanceKey(processInstanceKey);
        record.setBpmnElementType(process.getProcess().getElementById(elementId).getElementType());
        record.setElementId(elementId);
        record.setFlowScopeKey(flowScopeKey);
        return record;
    }

    record Rejection(RejectionType type, String reason) {
    }

    record ElementIdAndType(String elementId, BpmnElementType elementType) {
    }
}

