/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.processinstance;

import io.camunda.zeebe.engine.api.TypedRecord;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.KeyGenerator;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceModificationRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceModificationIntent;

public final class ProcessInstanceModificationProcessor
implements TypedRecordProcessor<ProcessInstanceModificationRecord> {
    private final StateWriter stateWriter;
    private final TypedResponseWriter responseWriter;
    private final KeyGenerator keyGenerator;

    public ProcessInstanceModificationProcessor(Writers writers, KeyGenerator keyGenerator) {
        this.stateWriter = writers.state();
        this.responseWriter = writers.response();
        this.keyGenerator = keyGenerator;
    }

    @Override
    public void processRecord(TypedRecord<ProcessInstanceModificationRecord> command) {
        ProcessInstanceModificationRecord record = command.getValue();
        long eventKey = this.keyGenerator.nextKey();
        this.stateWriter.appendFollowUpEvent(eventKey, (Intent)ProcessInstanceModificationIntent.MODIFIED, (RecordValue)record);
        this.responseWriter.writeEventOnCommand(eventKey, (Intent)ProcessInstanceModificationIntent.MODIFIED, (UnpackedObject)record, command);
    }
}

