/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.scheduled;

import io.camunda.zeebe.engine.api.ProcessingScheduleService;
import io.camunda.zeebe.engine.api.ReadonlyStreamProcessorContext;
import io.camunda.zeebe.engine.api.StreamProcessorLifecycleAware;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.LegacyTypedCommandWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.LegacyTypedStreamWriter;
import io.camunda.zeebe.scheduler.clock.ActorClock;
import java.time.Duration;
import java.util.function.Function;

public final class DueDateChecker
implements StreamProcessorLifecycleAware {
    private ProcessingScheduleService scheduleService;
    private LegacyTypedStreamWriter streamWriter;
    private boolean checkerRunning;
    private boolean shouldRescheduleChecker;
    private long nextDueDate = -1L;
    private final long timerResolution;
    private final Function<LegacyTypedCommandWriter, Long> nextDueDateSupplier;

    public DueDateChecker(long timerResolution, Function<LegacyTypedCommandWriter, Long> nextDueDateFunction) {
        this.timerResolution = timerResolution;
        this.nextDueDateSupplier = nextDueDateFunction;
    }

    public void schedule(long dueDate) {
        Duration delay = this.calculateDelayForNextRun(dueDate);
        if (this.shouldRescheduleChecker) {
            if (!this.checkerRunning) {
                this.scheduleService.runDelayed(delay, this::triggerEntities);
                this.nextDueDate = dueDate;
            } else if (this.nextDueDate - dueDate > this.timerResolution) {
                this.scheduleService.runDelayed(delay, this::triggerEntities);
                this.nextDueDate = dueDate;
            }
        }
    }

    private void triggerEntities() {
        if (this.shouldRescheduleChecker) {
            this.nextDueDate = this.nextDueDateSupplier.apply(this.streamWriter);
            if (this.nextDueDate > 0L) {
                Duration delay = this.calculateDelayForNextRun(this.nextDueDate);
                this.scheduleService.runDelayed(delay, this::triggerEntities);
                this.checkerRunning = true;
            } else {
                this.checkerRunning = false;
            }
        } else {
            this.checkerRunning = false;
        }
    }

    private Duration calculateDelayForNextRun(long dueDate) {
        return Duration.ofMillis(Math.max(dueDate - ActorClock.currentTimeMillis(), this.timerResolution));
    }

    @Override
    public void onRecovered(ReadonlyStreamProcessorContext processingContext) {
        this.scheduleService = processingContext.getScheduleService();
        this.streamWriter = processingContext.getLogStreamWriter();
        this.shouldRescheduleChecker = true;
        this.triggerEntities();
    }

    @Override
    public void onPaused() {
        this.shouldRescheduleChecker = false;
        this.nextDueDate = -1L;
    }

    @Override
    public void onResumed() {
        this.shouldRescheduleChecker = true;
        if (!this.checkerRunning) {
            this.triggerEntities();
        }
    }
}

