/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.streamprocessor.writers;

import io.camunda.zeebe.engine.api.TypedRecord;
import io.camunda.zeebe.engine.processing.streamprocessor.sideeffect.SideEffectProducer;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.CommandResponseWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.LegacyTypedResponseWriter;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class LegacyTypedResponseWriterImpl
implements LegacyTypedResponseWriter,
SideEffectProducer {
    private final CommandResponseWriter writer;
    private final int partitionId;
    private final UnsafeBuffer stringWrapper = new UnsafeBuffer(0L, 0);
    private long requestId;
    private int requestStreamId;
    private boolean isResponseStaged;

    public LegacyTypedResponseWriterImpl(CommandResponseWriter writer, int partitionId) {
        this.writer = writer;
        this.partitionId = partitionId;
    }

    @Override
    public void writeRejectionOnCommand(TypedRecord<?> command, RejectionType type, String reason) {
        byte[] bytes = reason.getBytes(StandardCharsets.UTF_8);
        this.stringWrapper.wrap(bytes);
        this.stage(RecordType.COMMAND_REJECTION, command.getIntent(), command.getKey(), type, (DirectBuffer)this.stringWrapper, command.getValueType(), command.getRequestId(), command.getRequestStreamId(), (UnpackedObject)command.getValue());
    }

    @Override
    public void writeEvent(TypedRecord<?> event) {
        this.stringWrapper.wrap(0L, 0);
        this.stage(RecordType.EVENT, event.getIntent(), event.getKey(), RejectionType.NULL_VAL, (DirectBuffer)this.stringWrapper, event.getValueType(), event.getRequestId(), event.getRequestStreamId(), (UnpackedObject)event.getValue());
    }

    @Override
    public void writeEventOnCommand(long eventKey, Intent eventState, UnpackedObject eventValue, TypedRecord<?> command) {
        this.stringWrapper.wrap(0L, 0);
        this.stage(RecordType.EVENT, eventState, eventKey, RejectionType.NULL_VAL, (DirectBuffer)this.stringWrapper, command.getValueType(), command.getRequestId(), command.getRequestStreamId(), eventValue);
    }

    @Override
    public void writeResponse(long eventKey, Intent eventState, UnpackedObject eventValue, ValueType valueType, long requestId, int requestStreamId) {
        this.stringWrapper.wrap(0L, 0);
        this.stage(RecordType.EVENT, eventState, eventKey, RejectionType.NULL_VAL, (DirectBuffer)this.stringWrapper, valueType, requestId, requestStreamId, eventValue);
    }

    @Override
    public void writeResponse(RecordType recordType, long key, Intent intent, UnpackedObject value, ValueType valueType, RejectionType rejectionType, String rejectionReason, long requestId, int requestStreamId) {
        byte[] bytes = rejectionReason.getBytes(StandardCharsets.UTF_8);
        this.stringWrapper.wrap(bytes);
        this.stage(recordType, intent, key, rejectionType, (DirectBuffer)this.stringWrapper, valueType, requestId, requestStreamId, value);
    }

    @Override
    public boolean flush() {
        if (this.isResponseStaged) {
            this.writer.tryWriteResponse(this.requestStreamId, this.requestId);
        }
        return true;
    }

    @Override
    public void reset() {
        this.isResponseStaged = false;
    }

    private void stage(RecordType type, Intent intent, long key, RejectionType rejectionType, DirectBuffer rejectionReason, ValueType valueType, long requestId, int requestStreamId, UnpackedObject value) {
        this.writer.partitionId(this.partitionId).key(key).intent(intent).recordType(type).valueType(valueType).rejectionType(rejectionType).rejectionReason(rejectionReason).valueWriter((BufferWriter)value);
        this.requestId = requestId;
        this.requestStreamId = requestStreamId;
        this.isResponseStaged = true;
    }
}

