/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.message;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbForeignKey;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.engine.state.ZbColumnFamilies;
import io.camunda.zeebe.engine.state.immutable.MessageState;
import io.camunda.zeebe.engine.state.message.StoredMessage;
import io.camunda.zeebe.engine.state.mutable.MutableMessageState;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageRecord;
import io.camunda.zeebe.util.EnsureUtil;
import org.agrona.DirectBuffer;

public final class DbMessageState
implements MutableMessageState {
    private final ColumnFamily<DbLong, StoredMessage> messageColumnFamily;
    private final DbLong messageKey = new DbLong();
    private final DbForeignKey<DbLong> fkMessage = new DbForeignKey((DbKey)this.messageKey, (Enum)ZbColumnFamilies.MESSAGE_KEY);
    private final StoredMessage message = new StoredMessage();
    private final DbString messageName;
    private final DbString correlationKey;
    private final DbCompositeKey<DbCompositeKey<DbString, DbString>, DbForeignKey<DbLong>> nameCorrelationMessageKey;
    private final DbCompositeKey<DbString, DbString> nameAndCorrelationKey;
    private final ColumnFamily<DbCompositeKey<DbCompositeKey<DbString, DbString>, DbForeignKey<DbLong>>, DbNil> nameCorrelationMessageColumnFamily;
    private final DbLong deadline;
    private final DbCompositeKey<DbLong, DbForeignKey<DbLong>> deadlineMessageKey;
    private final ColumnFamily<DbCompositeKey<DbLong, DbForeignKey<DbLong>>, DbNil> deadlineColumnFamily;
    private final DbString messageId;
    private final DbCompositeKey<DbCompositeKey<DbString, DbString>, DbString> nameCorrelationMessageIdKey;
    private final ColumnFamily<DbCompositeKey<DbCompositeKey<DbString, DbString>, DbString>, DbNil> messageIdColumnFamily;
    private final DbCompositeKey<DbForeignKey<DbLong>, DbString> messageBpmnProcessIdKey;
    private final DbString bpmnProcessIdKey;
    private final ColumnFamily<DbCompositeKey<DbForeignKey<DbLong>, DbString>, DbNil> correlatedMessageColumnFamily;
    private final DbCompositeKey<DbString, DbString> bpmnProcessIdCorrelationKey;
    private final ColumnFamily<DbCompositeKey<DbString, DbString>, DbNil> activeProcessInstancesByCorrelationKeyColumnFamiliy;
    private final DbLong processInstanceKey;
    private final ColumnFamily<DbLong, DbString> processInstanceCorrelationKeyColumnFamiliy;

    public DbMessageState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.messageColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.MESSAGE_KEY, transactionContext, (DbKey)this.messageKey, (DbValue)this.message);
        this.messageName = new DbString();
        this.correlationKey = new DbString();
        this.nameAndCorrelationKey = new DbCompositeKey((DbKey)this.messageName, (DbKey)this.correlationKey);
        this.nameCorrelationMessageKey = new DbCompositeKey(this.nameAndCorrelationKey, this.fkMessage);
        this.nameCorrelationMessageColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.MESSAGES, transactionContext, this.nameCorrelationMessageKey, (DbValue)DbNil.INSTANCE);
        this.deadline = new DbLong();
        this.deadlineMessageKey = new DbCompositeKey((DbKey)this.deadline, this.fkMessage);
        this.deadlineColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.MESSAGE_DEADLINES, transactionContext, this.deadlineMessageKey, (DbValue)DbNil.INSTANCE);
        this.messageId = new DbString();
        this.nameCorrelationMessageIdKey = new DbCompositeKey(this.nameAndCorrelationKey, (DbKey)this.messageId);
        this.messageIdColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.MESSAGE_IDS, transactionContext, this.nameCorrelationMessageIdKey, (DbValue)DbNil.INSTANCE);
        this.bpmnProcessIdKey = new DbString();
        this.messageBpmnProcessIdKey = new DbCompositeKey(this.fkMessage, (DbKey)this.bpmnProcessIdKey);
        this.correlatedMessageColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.MESSAGE_CORRELATED, transactionContext, this.messageBpmnProcessIdKey, (DbValue)DbNil.INSTANCE);
        this.bpmnProcessIdCorrelationKey = new DbCompositeKey((DbKey)this.bpmnProcessIdKey, (DbKey)this.correlationKey);
        this.activeProcessInstancesByCorrelationKeyColumnFamiliy = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.MESSAGE_PROCESSES_ACTIVE_BY_CORRELATION_KEY, transactionContext, this.bpmnProcessIdCorrelationKey, (DbValue)DbNil.INSTANCE);
        this.processInstanceKey = new DbLong();
        this.processInstanceCorrelationKeyColumnFamiliy = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.MESSAGE_PROCESS_INSTANCE_CORRELATION_KEYS, transactionContext, (DbKey)this.processInstanceKey, (DbValue)this.correlationKey);
    }

    @Override
    public void put(long key, MessageRecord record) {
        this.messageKey.wrapLong(key);
        this.message.setMessageKey(key).setMessage(record);
        this.messageColumnFamily.insert((DbKey)this.messageKey, (DbValue)this.message);
        this.messageName.wrapBuffer(record.getNameBuffer());
        this.correlationKey.wrapBuffer(record.getCorrelationKeyBuffer());
        this.nameCorrelationMessageColumnFamily.insert(this.nameCorrelationMessageKey, (DbValue)DbNil.INSTANCE);
        this.deadline.wrapLong(record.getDeadline());
        this.deadlineColumnFamily.insert(this.deadlineMessageKey, (DbValue)DbNil.INSTANCE);
        DirectBuffer messageId = record.getMessageIdBuffer();
        if (messageId.capacity() > 0) {
            this.messageId.wrapBuffer(messageId);
            this.messageIdColumnFamily.upsert(this.nameCorrelationMessageIdKey, (DbValue)DbNil.INSTANCE);
        }
    }

    @Override
    public void putMessageCorrelation(long messageKey, DirectBuffer bpmnProcessId) {
        EnsureUtil.ensureGreaterThan((String)"message key", (long)messageKey, (long)0L);
        EnsureUtil.ensureNotNullOrEmpty((String)"BPMN process id", (DirectBuffer)bpmnProcessId);
        this.messageKey.wrapLong(messageKey);
        this.bpmnProcessIdKey.wrapBuffer(bpmnProcessId);
        this.correlatedMessageColumnFamily.insert(this.messageBpmnProcessIdKey, (DbValue)DbNil.INSTANCE);
    }

    @Override
    public void removeMessageCorrelation(long messageKey, DirectBuffer bpmnProcessId) {
        EnsureUtil.ensureGreaterThan((String)"message key", (long)messageKey, (long)0L);
        EnsureUtil.ensureNotNullOrEmpty((String)"BPMN process id", (DirectBuffer)bpmnProcessId);
        this.messageKey.wrapLong(messageKey);
        this.bpmnProcessIdKey.wrapBuffer(bpmnProcessId);
        this.correlatedMessageColumnFamily.deleteExisting(this.messageBpmnProcessIdKey);
    }

    @Override
    public void putActiveProcessInstance(DirectBuffer bpmnProcessId, DirectBuffer correlationKey) {
        EnsureUtil.ensureNotNullOrEmpty((String)"BPMN process id", (DirectBuffer)bpmnProcessId);
        EnsureUtil.ensureNotNullOrEmpty((String)"correlation key", (DirectBuffer)correlationKey);
        this.bpmnProcessIdKey.wrapBuffer(bpmnProcessId);
        this.correlationKey.wrapBuffer(correlationKey);
        this.activeProcessInstancesByCorrelationKeyColumnFamiliy.insert(this.bpmnProcessIdCorrelationKey, (DbValue)DbNil.INSTANCE);
    }

    @Override
    public void removeActiveProcessInstance(DirectBuffer bpmnProcessId, DirectBuffer correlationKey) {
        EnsureUtil.ensureNotNullOrEmpty((String)"BPMN process id", (DirectBuffer)bpmnProcessId);
        EnsureUtil.ensureNotNullOrEmpty((String)"correlation key", (DirectBuffer)correlationKey);
        this.bpmnProcessIdKey.wrapBuffer(bpmnProcessId);
        this.correlationKey.wrapBuffer(correlationKey);
        this.activeProcessInstancesByCorrelationKeyColumnFamiliy.deleteExisting(this.bpmnProcessIdCorrelationKey);
    }

    @Override
    public void putProcessInstanceCorrelationKey(long processInstanceKey, DirectBuffer correlationKey) {
        EnsureUtil.ensureGreaterThan((String)"process instance key", (long)processInstanceKey, (long)0L);
        EnsureUtil.ensureNotNullOrEmpty((String)"correlation key", (DirectBuffer)correlationKey);
        this.processInstanceKey.wrapLong(processInstanceKey);
        this.correlationKey.wrapBuffer(correlationKey);
        this.processInstanceCorrelationKeyColumnFamiliy.insert((DbKey)this.processInstanceKey, (DbValue)this.correlationKey);
    }

    @Override
    public void removeProcessInstanceCorrelationKey(long processInstanceKey) {
        EnsureUtil.ensureGreaterThan((String)"process instance key", (long)processInstanceKey, (long)0L);
        this.processInstanceKey.wrapLong(processInstanceKey);
        this.processInstanceCorrelationKeyColumnFamiliy.deleteExisting((DbKey)this.processInstanceKey);
    }

    @Override
    public void remove(long key) {
        StoredMessage storedMessage = this.getMessage(key);
        if (storedMessage == null) {
            return;
        }
        this.messageKey.wrapLong(storedMessage.getMessageKey());
        this.messageColumnFamily.deleteExisting((DbKey)this.messageKey);
        this.messageName.wrapBuffer(storedMessage.getMessage().getNameBuffer());
        this.correlationKey.wrapBuffer(storedMessage.getMessage().getCorrelationKeyBuffer());
        this.nameCorrelationMessageColumnFamily.deleteExisting(this.nameCorrelationMessageKey);
        DirectBuffer messageId = storedMessage.getMessage().getMessageIdBuffer();
        if (messageId.capacity() > 0) {
            this.messageId.wrapBuffer(messageId);
            this.messageIdColumnFamily.deleteExisting(this.nameCorrelationMessageIdKey);
        }
        this.deadline.wrapLong(storedMessage.getMessage().getDeadline());
        this.deadlineColumnFamily.deleteExisting(this.deadlineMessageKey);
        this.correlatedMessageColumnFamily.whileEqualPrefix((DbKey)this.messageKey, (compositeKey, zbNil) -> this.correlatedMessageColumnFamily.deleteExisting((DbKey)compositeKey));
    }

    @Override
    public boolean existMessageCorrelation(long messageKey, DirectBuffer bpmnProcessId) {
        EnsureUtil.ensureGreaterThan((String)"message key", (long)messageKey, (long)0L);
        EnsureUtil.ensureNotNullOrEmpty((String)"BPMN process id", (DirectBuffer)bpmnProcessId);
        this.messageKey.wrapLong(messageKey);
        this.bpmnProcessIdKey.wrapBuffer(bpmnProcessId);
        return this.correlatedMessageColumnFamily.exists(this.messageBpmnProcessIdKey);
    }

    @Override
    public boolean existActiveProcessInstance(DirectBuffer bpmnProcessId, DirectBuffer correlationKey) {
        EnsureUtil.ensureNotNullOrEmpty((String)"BPMN process id", (DirectBuffer)bpmnProcessId);
        EnsureUtil.ensureNotNullOrEmpty((String)"correlation key", (DirectBuffer)correlationKey);
        this.bpmnProcessIdKey.wrapBuffer(bpmnProcessId);
        this.correlationKey.wrapBuffer(correlationKey);
        return this.activeProcessInstancesByCorrelationKeyColumnFamiliy.exists(this.bpmnProcessIdCorrelationKey);
    }

    @Override
    public DirectBuffer getProcessInstanceCorrelationKey(long processInstanceKey) {
        EnsureUtil.ensureGreaterThan((String)"process instance key", (long)processInstanceKey, (long)0L);
        this.processInstanceKey.wrapLong(processInstanceKey);
        DbString correlationKey = (DbString)this.processInstanceCorrelationKeyColumnFamiliy.get((DbKey)this.processInstanceKey);
        return correlationKey != null ? correlationKey.getBuffer() : null;
    }

    @Override
    public void visitMessages(DirectBuffer name, DirectBuffer correlationKey, MessageState.MessageVisitor visitor) {
        this.messageName.wrapBuffer(name);
        this.correlationKey.wrapBuffer(correlationKey);
        this.nameCorrelationMessageColumnFamily.whileEqualPrefix(this.nameAndCorrelationKey, (compositeKey, nil) -> {
            long messageKey = ((DbLong)((DbForeignKey)compositeKey.second()).inner()).getValue();
            StoredMessage message = this.getMessage(messageKey);
            return visitor.visit(message);
        });
    }

    @Override
    public StoredMessage getMessage(long messageKey) {
        this.messageKey.wrapLong(messageKey);
        return (StoredMessage)this.messageColumnFamily.get((DbKey)this.messageKey);
    }

    @Override
    public void visitMessagesWithDeadlineBefore(long timestamp, MessageState.MessageVisitor visitor) {
        this.deadlineColumnFamily.whileTrue((compositeKey, zbNil) -> {
            long deadline = ((DbLong)compositeKey.first()).getValue();
            if (deadline <= timestamp) {
                long messageKey = ((DbLong)((DbForeignKey)compositeKey.second()).inner()).getValue();
                StoredMessage message = this.getMessage(messageKey);
                return visitor.visit(message);
            }
            return false;
        });
    }

    @Override
    public boolean exist(DirectBuffer name, DirectBuffer correlationKey, DirectBuffer messageId) {
        this.messageName.wrapBuffer(name);
        this.correlationKey.wrapBuffer(correlationKey);
        this.messageId.wrapBuffer(messageId);
        return this.messageIdColumnFamily.exists(this.nameCorrelationMessageIdKey);
    }
}

