/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration;

import io.camunda.zeebe.engine.api.ReadonlyStreamProcessorContext;
import io.camunda.zeebe.engine.api.StreamProcessorLifecycleAware;
import io.camunda.zeebe.engine.state.migration.DbMigrator;
import io.camunda.zeebe.engine.state.migration.DbMigratorImpl;
import io.camunda.zeebe.engine.state.mutable.MutableZeebeState;
import java.util.function.Function;

public final class DbMigrationController
implements StreamProcessorLifecycleAware {
    private DbMigrator dbMigrator;
    private final Function<MutableZeebeState, DbMigrator> migratorFactory;

    public DbMigrationController() {
        this(DbMigratorImpl::new);
    }

    DbMigrationController(Function<MutableZeebeState, DbMigrator> migratorFactory) {
        this.migratorFactory = migratorFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onRecovered(ReadonlyStreamProcessorContext context) {
        DbMigrator migrator = this.migratorFactory.apply(context.getZeebeState());
        DbMigrationController dbMigrationController = this;
        synchronized (dbMigrationController) {
            this.dbMigrator = migrator;
        }
        try {
            migrator.runMigrations();
        }
        finally {
            dbMigrationController = this;
            synchronized (dbMigrationController) {
                this.dbMigrator = null;
            }
        }
    }

    @Override
    public final void onClose() {
        this.abortMigrationIfRunning();
    }

    @Override
    public final void onFailed() {
        this.abortMigrationIfRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void abortMigrationIfRunning() {
        DbMigrationController dbMigrationController = this;
        synchronized (dbMigrationController) {
            if (this.dbMigrator != null) {
                this.dbMigrator.abort();
            }
        }
    }
}

