/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.streamprocessor;

import io.camunda.zeebe.engine.api.PostCommitTask;
import io.camunda.zeebe.engine.api.ProcessingResult;
import io.camunda.zeebe.engine.api.ProcessingResultBuilder;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedEventRegistry;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.streamprocessor.BufferedStreamWriter;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BinaryOperator;

final class BufferedProcessingResultBuilder
implements ProcessingResultBuilder {
    private final Map<Class<? extends UnpackedObject>, ValueType> typeRegistry;
    private final BufferedStreamWriter bufferedStreamWriter;
    private final List<PostCommitTask> postCommitTasks = new ArrayList<PostCommitTask>();
    private final int sourceIndex;

    BufferedProcessingResultBuilder(BinaryOperator<Integer> capacityCalculator, int maxEventLength, int sourceIndex) {
        this.bufferedStreamWriter = new BufferedStreamWriter(capacityCalculator, maxEventLength);
        this.sourceIndex = sourceIndex;
        this.typeRegistry = new HashMap<Class<? extends UnpackedObject>, ValueType>();
        TypedEventRegistry.EVENT_REGISTRY.forEach((e, c) -> this.typeRegistry.put((Class<? extends UnpackedObject>)c, (ValueType)e));
    }

    @Override
    public ProcessingResultBuilder appendRecord(long key, RecordType type, Intent intent, RejectionType rejectionType, String rejectionReason, RecordValue value) {
        ValueType valueType = this.initValueType(value);
        BufferWriter valueWriter = this.initValueWriter(value);
        this.bufferedStreamWriter.appendRecord(key, this.sourceIndex, type, intent, rejectionType, rejectionReason, valueType, valueWriter);
        return this;
    }

    @Override
    public ProcessingResultBuilder withResponse(RecordType recordType, long key, Intent intent, UnpackedObject value, ValueType valueType, RejectionType rejectionType, String rejectionReason, long requestId, int requestStreamId) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public ProcessingResultBuilder appendPostCommitTask(PostCommitTask r) {
        this.postCommitTasks.add(r);
        return this;
    }

    @Override
    public ProcessingResultBuilder reset() {
        this.bufferedStreamWriter.reset();
        this.postCommitTasks.clear();
        return this;
    }

    @Override
    public ProcessingResultBuilder resetPostCommitTasks() {
        this.postCommitTasks.clear();
        return this;
    }

    @Override
    public ProcessingResult build() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public boolean canWriteEventOfLength(int eventLength) {
        return this.bufferedStreamWriter.canWriteAdditionalEvent(eventLength);
    }

    @Override
    public int getMaxEventLength() {
        return this.bufferedStreamWriter.getMaxEventLength();
    }

    private ValueType initValueType(RecordValue value) {
        ValueType valueType = this.typeRegistry.get(value.getClass());
        if (valueType == null) {
            throw new IllegalArgumentException("Missing value type mapping for record: " + value.getClass());
        }
        return valueType;
    }

    private BufferWriter initValueWriter(RecordValue value) {
        if (!(value instanceof BufferWriter)) {
            throw new IllegalArgumentException(String.format("The record value %s is not a BufferWriter", value));
        }
        return (BufferWriter)value;
    }
}

