/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.streamprocessor;

import io.camunda.zeebe.protocol.Protocol;
import io.camunda.zeebe.protocol.impl.record.RecordMetadata;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.util.function.BinaryOperator;
import org.agrona.ExpandableDirectByteBuffer;
import org.agrona.MutableDirectBuffer;

final class BufferedStreamWriter {
    private static final int INITIAL_BUFFER_CAPACITY = 32768;
    private final MutableDirectBuffer recordBuffer = new ExpandableDirectByteBuffer(32768);
    private final RecordMetadata metadata = new RecordMetadata();
    private int recordBufferOffset;
    private int recordCount;
    private final BinaryOperator<Integer> capacityCalculator;
    private final int maxEventLength;

    BufferedStreamWriter(BinaryOperator<Integer> capacityCalculator, int maxEventLength) {
        this.reset();
        this.capacityCalculator = capacityCalculator;
        this.maxEventLength = maxEventLength;
    }

    MutableDirectBuffer getRecordBuffer() {
        return this.recordBuffer;
    }

    int getRecordBufferOffset() {
        return this.recordBufferOffset;
    }

    int getRecordCount() {
        return this.recordCount;
    }

    void appendRecord(long key, int sourceIndex, RecordType type, Intent intent, RejectionType rejectionType, String rejectionReason, ValueType valueType, BufferWriter valueWriter) {
        this.writeKey(key);
        this.writeSourceIndex(sourceIndex);
        this.initMetadata(type, intent, rejectionType, rejectionReason, valueType);
        int metadataLength = this.metadata.getLength();
        this.writeMetadataLength(metadataLength);
        int valueLength = valueWriter.getLength();
        this.writeValueLength(valueLength);
        this.writeMetadata(metadataLength);
        this.writeValue(valueWriter, valueLength);
        ++this.recordCount;
    }

    boolean canWriteAdditionalEvent(int length) {
        return length < (Integer)this.capacityCalculator.apply(this.recordCount, this.recordBufferOffset);
    }

    private void writeKey(long key) {
        if (key < 0L) {
            key = -1L;
        }
        this.recordBuffer.putLong(this.recordBufferOffset, key, Protocol.ENDIANNESS);
        this.recordBufferOffset += 8;
    }

    private void writeSourceIndex(int sourceIndex) {
        this.recordBuffer.putInt(this.recordBufferOffset, sourceIndex, Protocol.ENDIANNESS);
        this.recordBufferOffset += 4;
    }

    private void initMetadata(RecordType type, Intent intent, RejectionType rejectionType, String rejectionReason, ValueType valueType) {
        this.metadata.reset();
        this.metadata.recordType(type).valueType(valueType).intent(intent).rejectionType(rejectionType).rejectionReason(rejectionReason);
    }

    private void writeMetadataLength(int metadataLength) {
        this.recordBuffer.putInt(this.recordBufferOffset, metadataLength, Protocol.ENDIANNESS);
        this.recordBufferOffset += 4;
    }

    private void writeValueLength(int valueLength) {
        this.recordBuffer.putInt(this.recordBufferOffset, valueLength, Protocol.ENDIANNESS);
        this.recordBufferOffset += 4;
    }

    private void writeMetadata(int metadataLength) {
        if (metadataLength > 0) {
            this.metadata.write(this.recordBuffer, this.recordBufferOffset);
            this.recordBufferOffset += metadataLength;
        }
    }

    private void writeValue(BufferWriter valueWriter, int valueLength) {
        valueWriter.write(this.recordBuffer, this.recordBufferOffset);
        this.recordBufferOffset += valueLength;
    }

    void reset() {
        this.recordBufferOffset = 0;
        this.recordCount = 0;
        this.metadata.reset();
    }

    public int getMaxEventLength() {
        return this.maxEventLength;
    }
}

