/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.streamprocessor;

import io.camunda.zeebe.engine.api.PostCommitTask;
import io.camunda.zeebe.engine.api.ProcessingResult;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.CommandResponseWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.LegacyTypedResponseWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.LegacyTypedStreamWriter;
import io.camunda.zeebe.logstreams.log.LogStreamBatchWriter;
import io.camunda.zeebe.streamprocessor.StreamProcessorContext;
import java.util.ArrayList;
import java.util.List;

final class DirectProcessingResult
implements ProcessingResult {
    private final List<PostCommitTask> postCommitTasks;
    private final LegacyTypedStreamWriter streamWriter;
    private final LegacyTypedResponseWriter responseWriter;
    private boolean hasResponse;

    DirectProcessingResult(StreamProcessorContext context, List<PostCommitTask> postCommitTasks, boolean hasResponse) {
        this.postCommitTasks = new ArrayList<PostCommitTask>(postCommitTasks);
        this.streamWriter = context.getLogStreamWriter();
        this.responseWriter = context.getTypedResponseWriter();
        this.hasResponse = hasResponse;
    }

    @Override
    public long writeRecordsToStream(LogStreamBatchWriter logStreamBatchWriter) {
        return this.streamWriter.flush();
    }

    @Override
    public boolean writeResponse(CommandResponseWriter commandResponseWriter) {
        if (this.hasResponse) {
            this.hasResponse = false;
            return this.responseWriter.flush();
        }
        return true;
    }

    @Override
    public boolean executePostCommitTasks() {
        boolean aggregatedResult = true;
        for (PostCommitTask task : this.postCommitTasks) {
            try {
                aggregatedResult = aggregatedResult && task.flush();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return aggregatedResult;
    }
}

