/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.streamprocessor;

import io.camunda.zeebe.engine.api.PostCommitTask;
import io.camunda.zeebe.engine.api.ProcessingResult;
import io.camunda.zeebe.engine.api.ProcessingResultBuilder;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.LegacyTypedResponseWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.LegacyTypedStreamWriter;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.streamprocessor.DirectProcessingResult;
import io.camunda.zeebe.streamprocessor.StreamProcessorContext;
import java.util.ArrayList;
import java.util.List;

final class DirectProcessingResultBuilder
implements ProcessingResultBuilder {
    private final List<PostCommitTask> postCommitTasks = new ArrayList<PostCommitTask>();
    private final StreamProcessorContext context;
    private final LegacyTypedStreamWriter streamWriter;
    private final LegacyTypedResponseWriter responseWriter;
    private boolean hasResponse = true;
    private final long sourceRecordPosition;

    DirectProcessingResultBuilder(StreamProcessorContext context, long sourceRecordPosition) {
        this.context = context;
        this.sourceRecordPosition = sourceRecordPosition;
        this.streamWriter = context.getLogStreamWriter();
        this.streamWriter.configureSourceContext(sourceRecordPosition);
        this.responseWriter = context.getTypedResponseWriter();
    }

    @Override
    public ProcessingResultBuilder appendRecord(long key, RecordType type, Intent intent, RejectionType rejectionType, String rejectionReason, RecordValue value) {
        this.streamWriter.appendRecord(key, type, intent, rejectionType, rejectionReason, value);
        return this;
    }

    @Override
    public ProcessingResultBuilder withResponse(RecordType recordType, long key, Intent intent, UnpackedObject value, ValueType valueType, RejectionType rejectionType, String rejectionReason, long requestId, int requestStreamId) {
        this.hasResponse = true;
        this.responseWriter.writeResponse(recordType, key, intent, value, valueType, rejectionType, rejectionReason, requestId, requestStreamId);
        return this;
    }

    @Override
    public ProcessingResultBuilder appendPostCommitTask(PostCommitTask task) {
        this.postCommitTasks.add(task);
        return this;
    }

    @Override
    public ProcessingResultBuilder reset() {
        this.streamWriter.reset();
        this.streamWriter.configureSourceContext(this.sourceRecordPosition);
        this.responseWriter.reset();
        this.postCommitTasks.clear();
        return this;
    }

    @Override
    public ProcessingResultBuilder resetPostCommitTasks() {
        this.postCommitTasks.clear();
        return this;
    }

    @Override
    public ProcessingResult build() {
        return new DirectProcessingResult(this.context, this.postCommitTasks, this.hasResponse);
    }

    @Override
    public boolean canWriteEventOfLength(int eventLength) {
        return this.streamWriter.canWriteEventOfLength(eventLength);
    }

    @Override
    public int getMaxEventLength() {
        return this.streamWriter.getMaxEventLength();
    }
}

